@extends('layouts.admin') {{-- Your TALL stack admin layout --}}

@section('title', 'Project Details: ' . $project->name)

@section('content_header')
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Project Details: <span class="font-normal">{{ $project->name }}</span></h1>
        </div>
        <div>
            <a href="{{ route('admin.businessdirectory.projects.edit', $project->id) }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-500 active:bg-indigo-700 focus:outline-none focus:border-indigo-700 focus:ring focus:ring-indigo-300 disabled:opacity-25 transition"><i class="fas fa-edit mr-2"></i> Edit Project</a>
            <a href="{{ route('admin.businessdirectory.projects.index') }}" class="ml-3 inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-gray-700 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-300 dark:hover:bg-gray-500 active:bg-gray-400 focus:outline-none focus:border-gray-400 focus:ring focus:ring-gray-300 disabled:opacity-25 transition">&larr; Back to Projects</a>
        </div>
    </div>
@stop

@section('content')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    {{-- Project Information Card --}}
    <div class="bg-white shadow-lg rounded-lg overflow-hidden mb-8">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-700">
            <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-100">{{ $project->name }}</h2>
        </div>
        <div class="px-6 py-4 dark:bg-gray-800">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 text-sm text-gray-700 dark:text-gray-300">
                <div>
                    <strong class="block text-gray-500 dark:text-gray-400">Owning Company:</strong>
                    <a href="{{ $project->company ? route('admin.businessdirectory.companies.show', $project->company->id) : '#' }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
                        {{ $project->company->name ?? 'N/A' }}
                    </a>
                </div>
                <div>
                    <strong class="block text-gray-500 dark:text-gray-400">Status:</strong>
                    @php
                        $statusConfig = \Modules\BusinessDirectory\Entities\CompanyProject::getStatusConfig($project->status);
                    @endphp
                    <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $statusConfig['tailwind_class'] }}">
                        {{ $statusConfig['label'] }}
                    </span>
                </div>
                <div>
                    <strong class="block text-gray-500 dark:text-gray-400">Start Date:</strong>
                    {{ $project->start_date ? $project->start_date->format('M d, Y') : 'N/A' }}
                </div>
                <div>
                    <strong class="block text-gray-500 dark:text-gray-400">End Date:</strong>
                    {{ $project->end_date ? $project->end_date->format('M d, Y') : 'N/A' }}
                </div>
                <div>
                    <strong class="block text-gray-500 dark:text-gray-400">Budget:</strong>
                    {{ $project->budget ? ($project->currency ?? setting('site_currency_symbol','$')) . number_format($project->budget, 2) : 'N/A' }}
                </div>
                @if($project->clientCompany)
                <div>
                    <strong class="block text-gray-500 dark:text-gray-400">Client Company:</strong>
                     <a href="{{ route('admin.businessdirectory.companies.show', $project->clientCompany->id) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
                        {{ $project->clientCompany->name }}
                    </a>
                </div>
                @endif
            </div>
            @if($project->description)
            <div class="mt-6 ">
                <strong class="block text-gray-600 dark:text-gray-400 mb-1">Description:</strong>
                <div class="prose prose-sm max-w-none text-gray-700 dark:text-gray-300 dark:prose-invert">
                    {!! nl2br(e($project->description)) !!}
                </div>
            </div>
            @endif
        </div>
    </div>

    {{-- Tasks Section --}}
    <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 bg-indigo-50 dark:bg-indigo-900 flex justify-between items-center">
            <h3 class="text-lg font-semibold text-indigo-700 dark:text-indigo-300">Project Tasks ({{ $project->tasks->count() }})</h3>
            <a href="{{ route('admin.businessdirectory.projects.tasks.create', $project->id) }}"
               class="inline-flex items-center px-3 py-2 bg-green-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-500 active:bg-green-700 focus:outline-none focus:border-green-700 focus:ring focus:ring-green-300 disabled:opacity-25 transition">
                <i class="fas fa-plus mr-1"></i>Add Task
            </a>
        </div>
        <div class="divide-y divide-gray-200 dark:divide-gray-700">
            @if($project->tasks->isNotEmpty())
                @foreach($project->tasks as $task)
                    <div class="px-6 py-4 hover:bg-gray-50 dark:hover:bg-gray-700">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-md font-semibold text-gray-900 dark:text-gray-100">{{ $task->title }}</p>
                                <p class="text-xs text-gray-500 dark:text-gray-400">
                                    Status: <span class="font-medium">{{ ucfirst(str_replace('_', ' ', $task->status)) }}</span>
                                    @if($task->priority)
                                    | Priority: <span class="font-medium">{{ ucfirst($task->priority) }}</span>
                                    @endif
                                </p>
                            </div>
                            <div class="text-sm text-gray-500 dark:text-gray-400">
                                @if($task->due_date)
                                    Due: {{ $task->due_date->format('M d, Y') }}
                                @endif
                            </div>
                        </div>
                        @if($task->description)
                        <p class="mt-2 text-sm text-gray-600">
                            {{ Str::limit($task->description, 150) }} {{-- Consider making this expandable or linking to task details --}}
                        </p>
                        @endif
                        <div class="mt-3 flex items-center justify-between">
                            <p class="text-xs text-gray-500 dark:text-gray-400">
                                Assignee: {{ $task->assignee->name ?? 'Unassigned' }}
                            </p>
                            <div class="space-x-2">
                                <a href="{{ route('admin.businessdirectory.projects.tasks.edit', ['project' => $project->id, 'task' => $task->id]) }}"
                                   class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300 text-xs font-medium">Edit</a>
                                <button type="button" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300 text-xs font-medium delete-task-item"
                                        data-task-id="{{ $task->id }}"
                                        data-project-id="{{ $project->id }}">
                                    Delete
                                </button>
                            </div>
                        </div>
                    </div>
                @endforeach
            @else
                <p class="text-center text-gray-500 py-6">No tasks have been added to this project yet.</p>
            @endif
        </div>
    </div>
</div>
@stop

@push('js')
<script>
$(function () {
    // Handle Task Delete
    $('.delete-task-item').on('click', function () {
        var taskId = $(this).data('task-id');
        var projectId = $(this).data('project-id');
        var deleteUrl = "{{ url('admin/businessdirectory/projects') }}/" + projectId + "/tasks/" + taskId;

        if (confirm('Are you sure you want to delete this task? This action cannot be undone.')) {
            $.ajax({
                url: deleteUrl,
                type: 'POST',
                data: {
                    _method: 'DELETE',
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    if(response.success) {
                        // Reload the page or remove the task item from DOM
                        // For simplicity, reloading the page:
                        window.location.reload();
                        // alert(response.success); // Placeholder for better notification
                    } else if (response.error) {
                        alert(response.error); // Placeholder
                    }
                },
                error: function(xhr) {
                    alert('An error occurred while deleting the task.'); // Placeholder
                    console.error(xhr.responseText);
                }
            });
        }
    });
});
</script>
@endpush

{{--
    You will also need to create:
    - businessdirectory::admin.tasks.create (form to add a task to a project)
    - businessdirectory::admin.tasks.edit (form to edit an existing task)
    These can be simpler forms, perhaps loaded in modals or on separate pages.
--}}