@extends('layouts.admin') {{-- Your TALL stack admin layout --}}

@section('title', 'Edit Project: ' . $project->name)

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Edit Project: <span class="font-normal">{{ $project->name }}</span></h1>
        <a href="{{ route('admin.businessdirectory.projects.index') }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
            &larr; Back to Projects
        </a>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <form action="{{ route('admin.businessdirectory.projects.update', $project->id) }}" method="POST" enctype="multipart/form-data"> {{-- Add enctype if projects can have images/files --}}
        @csrf
        @method('PUT')
        {{-- Pass necessary variables to the form partial --}}
        @include('businessdirectory::admin.projects._form', ['project' => $project, 'companies' => $companies, 'project_statuses' => $project_statuses])
    </form>
</div>
@endsection