<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    {{-- Main Project Information --}}
    <div class="lg:col-span-2 bg-white shadow-md rounded-lg p-6">
        <div class="space-y-6">
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Project Name <span class="text-red-500">*</span></label>
                <input type="text" name="name" id="name" value="{{ old('name', $project->name ?? '') }}" required
                       class="mt-1 form-input block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('name') border-red-500 @enderror">
                @error('name') <p class="mt-1 text-xs text-red-500 dark:text-red-400">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="company_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Owning Company <span class="text-red-500">*</span></label>
                <select name="company_id" id="company_id" required
                        class="mt-1 form-select block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md @error('company_id') border-red-500 @enderror">
                    <option value="">Select Owning Company</option>
                    @foreach($companies ?? [] as $id => $name)
                        <option value="{{ $id }}" {{ (old('company_id', $project->company_id ?? '') == $id) ? 'selected' : '' }}>
                            {{ $name }}
                        </option>
                    @endforeach
                </select>
                @error('company_id') <p class="mt-1 text-xs text-red-500 dark:text-red-400">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description</label>
                <textarea name="description" id="description" rows="6"
                          class="mt-1 form-textarea block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('description') border-red-500 @enderror">{{ old('description', $project->description ?? '') }}</textarea>
                @error('description') <p class="mt-1 text-xs text-red-500 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
        </div>
    </div>

    {{-- Project Settings & Meta --}}
    <div class="lg:col-span-1 bg-white dark:bg-gray-800 shadow-md rounded-lg p-6 space-y-6">
        <div>
            <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
            <select name="status" id="status" required
                    class="mt-1 form-select block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md @error('status') border-red-500 @enderror">
                @foreach($project_statuses ?? [] as $key => $value)
                    <option value="{{ $key }}" {{ (old('status', $project->status ?? 'draft') == $key) ? 'selected' : '' }}>
                        {{ $value }}
                    </option>
                @endforeach
            </select>
            @error('status') <p class="mt-1 text-xs text-red-500 dark:text-red-400">{{ $message }}</p> @enderror
        </div>

        <div>
            <label for="start_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Start Date</label>
            <input type="date" name="start_date" id="start_date" value="{{ old('start_date', isset($project->start_date) ? $project->start_date->format('Y-m-d') : '') }}"
                   class="mt-1 form-input block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('start_date') border-red-500 @enderror">
            @error('start_date') <p class="mt-1 text-xs text-red-500 dark:text-red-400">{{ $message }}</p> @enderror
        </div>

        <div>
            <label for="end_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">End Date</label>
            <input type="date" name="end_date" id="end_date" value="{{ old('end_date', isset($project->end_date) ? $project->end_date->format('Y-m-d') : '') }}"
                   class="mt-1 form-input block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('end_date') border-red-500 @enderror">
            @error('end_date') <p class="mt-1 text-xs text-red-500 dark:text-red-400">{{ $message }}</p> @enderror
        </div>

        <div class="grid grid-cols-2 gap-4">
            <div>
                <label for="budget" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Budget</label>
                <input type="number" name="budget" id="budget" step="0.01" value="{{ old('budget', $project->budget ?? '') }}"
                       class="mt-1 form-input block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('budget') border-red-500 @enderror" placeholder="e.g., 5000.00">
                @error('budget') <p class="mt-1 text-xs text-red-500 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div>
                <label for="currency" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Currency</label>
                <input type="text" name="currency" id="currency" value="{{ old('currency', $project->currency ?? 'USD') }}"
                       class="mt-1 form-input block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('currency') border-red-500 @enderror" placeholder="e.g., USD">
                @error('currency') <p class="mt-1 text-xs text-red-500 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
        </div>

        <div>
            <label for="client_company_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Client Company (Optional)</label>
            <select name="client_company_id" id="client_company_id"
                    class="mt-1 form-select block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md @error('client_company_id') border-red-500 @enderror">
                <option value="">Select Client Company (if applicable)</option>
                @foreach($companies ?? [] as $id => $name) {{-- Assuming $companies is passed for both owning and client --}}
                    <option value="{{ $id }}" {{ (old('client_company_id', $project->client_company_id ?? '') == $id) ? 'selected' : '' }}>
                        {{ $name }}
                    </option>
                @endforeach
            </select>
            @error('client_company_id') <p class="mt-1 text-xs text-red-500 dark:text-red-400">{{ $message }}</p> @enderror
        </div>

        <div class="pt-5">
            <div class="flex justify-end">
                <a href="{{ route('admin.businessdirectory.projects.index') }}"
                   class="bg-white dark:bg-gray-600 dark:hover:bg-gray-500 dark:text-gray-200 py-2 px-4 border border-gray-300 dark:border-gray-500 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Cancel
                </a>
                <button type="submit"
                        class="ml-3 inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    {{ isset($project) ? 'Update Project' : 'Create Project' }}
                </button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Initialize Select2 or other JS libraries if needed
    // For example, if you use a rich text editor for description:
    // tinymce.init({
    //  selector: '#description',
    //  plugins: 'advlist autolink lists link image charmap print preview hr anchor pagebreak',
    //  toolbar_mode: 'floating',
    // });
</script>
@endpush