@csrf
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 p-6">
    {{-- Main Column for Product Details & SEO --}}
    <div class="md:col-span-2 space-y-6">
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Product Details</h3>
            </div>
            <div class="p-6 space-y-6">
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Product Name <span class="text-red-500">*</span></label>
                    <input type="text" name="name" id="name" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('name') border-red-500 @enderror" value="{{ old('name', $product->name ?? '') }}" required>
                    @error('name') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description</label>
                    <textarea name="description" id="description" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('description') border-red-500 @enderror" rows="8">{{ old('description', $product->description ?? '') }}</textarea>
                    @error('description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                    <div>
                        <label for="price" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Price ({{ setting('site_currency_symbol', '$') }}) <span class="text-red-500">*</span></label>
                        <input type="number" name="price" id="price" step="0.01" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('price') border-red-500 @enderror" value="{{ old('price', $product->price ?? '') }}" required>
                        @error('price') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="sku" class="block text-sm font-medium text-gray-700 dark:text-gray-300">SKU</label>
                        <input type="text" name="sku" id="sku" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('sku') border-red-500 @enderror" value="{{ old('sku', $product->sku ?? '') }}">
                        @error('sku') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="stock_quantity" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Stock Quantity</label>
                        <input type="number" name="stock_quantity" id="stock_quantity" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('stock_quantity') border-red-500 @enderror" value="{{ old('stock_quantity', $product->stock_quantity ?? '') }}">
                        @error('stock_quantity') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                </div>

                <div>
                    <label for="category_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Category</label>
                    <select name="category_id" id="category_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('category_id') border-red-500 @enderror">
                        <option value="">Select Category</option>
                        @foreach($categories ?? [] as $id => $name)
                            <option value="{{ $id }}" {{ (old('category_id', $product->category_id ?? '') == $id) ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                    @error('category_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <hr class="dark:border-gray-700">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white">Shipping Details (Optional)</h3>
                 <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4">
                    <div>
                        <label for="weight" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Weight (kg)</label>
                        <input type="number" name="weight" id="weight" step="0.01" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('weight') border-red-500 @enderror" value="{{ old('weight', $product->weight ?? '') }}">
                        @error('weight') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="dimensions_length" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Length (cm)</label>
                        <input type="number" name="dimensions[length]" id="dimensions_length" step="0.1" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('dimensions.length') border-red-500 @enderror" value="{{ old('dimensions.length', $product->dimensions['length'] ?? '') }}">
                        @error('dimensions.length') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="dimensions_width" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Width (cm)</label>
                        <input type="number" name="dimensions[width]" id="dimensions_width" step="0.1" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('dimensions.width') border-red-500 @enderror" value="{{ old('dimensions.width', $product->dimensions['width'] ?? '') }}">
                        @error('dimensions.width') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                     <div>
                        <label for="dimensions_height" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Height (cm)</label>
                        <input type="number" name="dimensions[height]" id="dimensions_height" step="0.1" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('dimensions.height') border-red-500 @enderror" value="{{ old('dimensions.height', $product->dimensions['height'] ?? '') }}">
                        @error('dimensions.height') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                </div>

                <hr class="dark:border-gray-700">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white">SEO Information (Optional)</h3>
                 <div>
                    <label for="meta_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Title</label>
                    <input type="text" name="meta_title" id="meta_title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_title') border-red-500 @enderror" value="{{ old('meta_title', $product->meta_title ?? '') }}">
                    @error('meta_title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label for="meta_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Description</label>
                    <textarea name="meta_description" id="meta_description" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_description') border-red-500 @enderror" rows="2">{{ old('meta_description', $product->meta_description ?? '') }}</textarea>
                    @error('meta_description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                 <div>
                    <label for="tags" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Tags (comma-separated)</label>
                    <input type="text" name="tags" id="tags" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('tags') border-red-500 @enderror" value="{{ old('tags', $product->tags ?? '') }}">
                    @error('tags') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
            </div>
        </div>
    </div>
    {{-- Sidebar Column for Publishing & Images --}}
    <div class="md:col-span-1 space-y-6">
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Publishing & Images</h3>
            </div>
            <div class="p-6 space-y-6">
                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
                    <select name="status" id="status" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('status') border-red-500 @enderror" required>
                        @foreach($statuses ?? [] as $key => $value)
                            <option value="{{ $key }}" {{ (old('status', $product->status ?? 'draft') == $key) ? 'selected' : '' }}>{{ $value }}</option>
                        @endforeach
                    </select>
                    @error('status') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div class="flex items-center">
                    <input type="checkbox" name="is_published" id="is_published" class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500" value="1" {{ old('is_published', $product->is_published ?? false) ? 'checked' : '' }}>
                    <label for="is_published" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Published (Visible on site)</label>
                </div>

                <div>
                    <label for="featured_image" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Featured Image</label>
                    <input type="file" name="featured_image" id="featured_image" class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-300 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 dark:file:bg-gray-600 file:text-indigo-700 dark:file:text-indigo-300 hover:file:bg-indigo-100 dark:hover:file:bg-gray-500 @error('featured_image') border-red-500 @enderror">
                    @error('featured_image') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    @if(isset($product) && $product->featured_image_url)
                        <div class="mt-2">
                            <img src="{{ $product->featured_image_url }}" alt="Current Featured Image" class="h-32 w-auto rounded-md object-contain">
                        </div>
                    @endif
                </div>

                <div>
                    <label for="gallery_images" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Gallery Images (Multiple)</label>
                    <input type="file" name="gallery_images[]" id="gallery_images" class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-300 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 dark:file:bg-gray-600 file:text-indigo-700 dark:file:text-indigo-300 hover:file:bg-indigo-100 dark:hover:file:bg-gray-500 @error('gallery_images.*') border-red-500 @enderror" multiple>
                    @error('gallery_images.*') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    @if(isset($product) && is_array($product->gallery_images_urls) && count($product->gallery_images_urls) > 0)
                        <div class="mt-2 flex flex-wrap gap-2">
                            @foreach($product->gallery_images_urls as $url)
                                <img src="{{ $url }}" alt="Gallery Image" class="h-20 w-20 rounded-md object-cover">
                            @endforeach
                        </div>
                        <div class="mt-2 flex items-center">
                            <input type="checkbox" name="remove_gallery_images" id="remove_gallery_images" class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500" value="1">
                            <label for="remove_gallery_images" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Remove all gallery images on update</label>
                        </div>
                    @endif
                </div>

                @if(isset($users))
                <div>
                    <label for="user_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Product Poster (User)</label>
                    <select name="user_id" id="user_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('user_id') border-red-500 @enderror">
                        <option value="">Default (Company Owner)</option>
                        @foreach($users as $id => $name)
                            <option value="{{ $id }}" {{ (old('user_id', $product->user_id ?? '') == $id) ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                    @error('user_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                @endif
            </div>
        </div>

        <div class="flex justify-end space-x-3">
            <a href="{{ route('admin.businessdirectory.companies.products.index', $company->id) }}" class="inline-flex justify-center py-2 px-4 border border-gray-300 dark:border-gray-500 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-600 hover:bg-gray-50 dark:hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Cancel
            </a>
            <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                {{ isset($product) && $product->id ? 'Update Product' : 'Create Product' }}
            </button>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Initialize WYSIWYG editor if you have one with class 'form-controlwysiwyg'
    // Example for CKEditor (ensure CKEditor script is loaded in your admin layout):
    // if (typeof ClassicEditor !== 'undefined') {
    //     ClassicEditor
    //         .create( document.querySelector( '#description' ) ) // Assuming your textarea has id="description"
    //         .catch( error => {
    //             console.error( error );
    //         } );
    // }
</script>
@endpush
