@extends('layouts.admin')

@section('title', 'Job Details: ' . $job->title)

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Job Details: <span class="font-normal">{{ $job->title }}</span></h1>
        <div>
            <a href="{{ route('admin.businessdirectory.jobs.edit', $job->id) }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-500 active:bg-indigo-700 focus:outline-none focus:border-indigo-700 focus:ring focus:ring-indigo-300 disabled:opacity-25 transition">
                <i class="fas fa-edit mr-2"></i>Edit Job
            </a>
            <a href="{{ route('admin.businessdirectory.jobs.index') }}" class="ml-3 inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-gray-700 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-300 dark:hover:bg-gray-500 active:bg-gray-400 focus:outline-none focus:border-gray-400 focus:ring focus:ring-gray-300 disabled:opacity-25 transition">
                &larr; Back to Jobs
            </a>
        </div>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8" x-data="{ coverLetterModalOpen: false, currentCoverLetter: '', currentApplicantName: '' }">
    @include('businessdirectory::admin.partials._alerts')

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        {{-- Job Details Column --}}
        <div class="md:col-span-2 bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">{{ $job->title }}</h3>
            </div>
            <div class="p-6">
                <dl class="grid grid-cols-1 sm:grid-cols-2 gap-x-4 gap-y-6">
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Company</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                            <a href="{{ $job->company ? route('admin.businessdirectory.companies.show', $job->company_id) : '#' }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
                                {{ $job->company->name ?? 'N/A' }}
                            </a>
                        </dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Status</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                            @php
                                $statusClass = match($job->status) {
                                    'open' => 'bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100',
                                    'closed' => 'bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100',
                                    'filled' => 'bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100',
                                    'draft' => 'bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100',
                                    default => 'bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200',
                                };
                            @endphp
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusClass }}">
                                {{ \Modules\BusinessDirectory\Entities\Job::getStatuses()[$job->status] ?? ucfirst($job->status) }}
                            </span>
                        </dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Job Type</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ \Modules\BusinessDirectory\Entities\Job::getJobTypes()[$job->job_type] ?? ucfirst($job->job_type ?? 'N/A') }}</dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Location</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $job->location ?? 'N/A' }}</dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Remote</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $job->is_remote ? 'bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100' : 'bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200' }}">
                                {{ $job->is_remote ? 'Yes' : 'No' }}
                            </span>
                        </dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Application Deadline</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $job->application_deadline ? $job->application_deadline->format('M d, Y') : 'N/A' }}</dd>
                    </div>
                    @if($job->salary_min || $job->salary_max)
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Salary</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                            {{ $job->salary_min ? ($job->currency ?? setting('site_currency_symbol','$')).number_format($job->salary_min) : '' }}
                            {{ ($job->salary_min && $job->salary_max) ? ' - ' : '' }}
                            {{ $job->salary_max ? ($job->currency ?? setting('site_currency_symbol','$')).number_format($job->salary_max) : '' }}
                        </dd>
                    </div>
                    @endif
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Experience Level</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $job->experience_level ?? 'N/A' }}</dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Education Level</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $job->education_level ?? 'N/A' }}</dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Views</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $job->views_count }}</dd>
                    </div>
                </dl>

                <hr class="my-4 dark:border-gray-700">

                <h4 class="text-md font-semibold text-gray-800 dark:text-gray-100 mb-2">Description</h4>
                <div class="prose dark:prose-invert max-w-none text-sm text-gray-600 dark:text-gray-300">
                    {!! $job->description !!}
                </div>

                @if($job->skills_required && (is_array($job->skills_required) && count($job->skills_required) > 0) || (!is_array($job->skills_required) && !empty($job->skills_required)))
                    <hr class="my-4 dark:border-gray-700">
                    <h4 class="text-md font-semibold text-gray-800 dark:text-gray-100 mb-2">Skills Required</h4>
                    <div class="flex flex-wrap gap-2">
                        @php
                            $skills = is_array($job->skills_required) ? $job->skills_required : explode(',', $job->skills_required);
                        @endphp
                        @foreach($skills as $skill)
                            @if(trim($skill))
                            <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-indigo-100 text-indigo-800 dark:bg-indigo-700 dark:text-indigo-100">
                                {{ trim($skill) }}
                            </span>
                            @endif
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        {{-- Job Applications Column --}}
        <div class="md:col-span-1 bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Job Applications ({{ $job->jobApplications->count() }})</h3>
            </div>
            <div class="divide-y divide-gray-200 dark:divide-gray-700">
                @forelse($job->jobApplications as $application)
                    <div class="p-4">
                        <div class="flex justify-between items-center">
                            <h4 class="text-sm font-semibold text-gray-800 dark:text-gray-100">{{ $application->user->name ?? 'N/A' }}</h4>
                            <span class="text-xs text-gray-500 dark:text-gray-400">{{ $application->applied_at->format('M d, Y') }}</span>
                        </div>
                        <div class="mt-2 flex justify-between items-center">
                            <div class="text-sm">
                                @if($application->resume_path)
                                    <a href="{{ Storage::url($application->resume_path) }}" target="_blank" class="inline-flex items-center text-xs text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300">
                                        <i class="fas fa-file-download mr-1"></i> Resume
                                    </a>
                                @else
                                    <span class="text-xs text-gray-400 dark:text-gray-500">No Resume</span>
                                @endif
                            </div>
                            <div>
                                <form action="{{ route('admin.businessdirectory.job-applications.updateStatus', $application->id) }}" method="POST" class="inline-block">
                                    @csrf
                                    <select name="status"
                                            class="form-select form-select-sm rounded-md shadow-sm text-xs dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300"
                                            onchange="this.form.submit()">
                                        @foreach(\Modules\BusinessDirectory\Entities\JobApplication::getStatuses() as $statusValue => $statusLabel)
                                            <option value="{{ $statusValue }}" {{ $application->status == $statusValue ? 'selected' : '' }}>
                                                {{ $statusLabel }}
                                            </option>
                                        @endforeach
                                    </select>
                                </form>
                            </div>
                        </div>
                        @if($application->cover_letter)
                        <div class="mt-2">
                            <p class="text-xs text-gray-500 dark:text-gray-400">Cover Letter:</p>
                            <p class="text-xs text-gray-600 dark:text-gray-300">
                                {{ Str::limit($application->cover_letter, 150) }}
                                @if(strlen($application->cover_letter) > 150)
                                <button @click="coverLetterModalOpen = true; currentCoverLetter = {{ json_encode($application->cover_letter) }}; currentApplicantName = {{ json_encode($application->user->name ?? 'Applicant') }};" class="text-blue-500 hover:underline text-xs ml-1">(Read more)</button>
                                @endif
                            </p>
                        </div>
                        @endif
                    </div>
                @empty
                    <p class="p-4 text-center text-sm text-gray-500 dark:text-gray-400">No applications received yet.</p>
                @endforelse
            </div>
        </div>
    </div>

    {{-- Cover Letter Modal --}}
    <div x-show="coverLetterModalOpen" class="fixed z-20 inset-0 overflow-y-auto" aria-labelledby="modal-title-cover-letter" role="dialog" aria-modal="true" style="display: none;">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div x-show="coverLetterModalOpen" @click.away="coverLetterModalOpen = false" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>
            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
            <div x-show="coverLetterModalOpen" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" class="inline-block align-bottom bg-white dark:bg-gray-800 rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full">
                <div class="bg-white dark:bg-gray-800 px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <div class="sm:flex sm:items-start">
                        <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white" id="modal-title-cover-letter" x-text="'Cover Letter - ' + currentApplicantName"></h3>
                            <div class="mt-2">
                                <p class="text-sm text-gray-600 dark:text-gray-300 whitespace-pre-wrap" x-text="currentCoverLetter"></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 dark:bg-gray-700 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <button type="button" @click="coverLetterModalOpen = false" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 dark:border-gray-600 shadow-sm px-4 py-2 bg-white dark:bg-gray-800 text-base font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
