@extends('layouts.admin')

@section('title', 'Manage Jobs')

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Manage Jobs</h1>
        <a href="{{ route('admin.businessdirectory.jobs.create') }}" class="inline-flex items-center px-4 py-2 bg-green-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-500 active:bg-green-700 focus:outline-none focus:border-green-700 focus:ring focus:ring-green-300 disabled:opacity-25 transition">
            <svg class="w-4 h-4 mr-2 -ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>
            Add New Job
        </a>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
        <div class="p-6">
            @include('businessdirectory::admin.partials._alerts') {{-- Make sure this partial is TALL stack styled --}}

            <form method="GET" action="{{ route('admin.businessdirectory.jobs.index') }}" class="mb-6">
                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4 items-end">
                    <div>
                        <label for="search_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Search Title</label>
                        <input type="text" name="search_title" id="search_title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300" value="{{ request('search_title') }}">
                    </div>
                    <div>
                        <label for="job_status_filter" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                        <select name="job_status_filter" id="job_status_filter" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300">
                            <option value="">All Statuses</option> {{-- Ensure $job_statuses_filter is passed from controller --}}
                            @foreach($job_statuses_filter ?? [] as $key => $value)
                                <option value="{{ $key }}" {{ request('job_status_filter') == $key ? 'selected' : '' }}>{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="flex space-x-2">
                        <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-500 active:bg-blue-700 focus:outline-none focus:border-blue-700 focus:ring focus:ring-blue-300 disabled:opacity-25 transition">Filter</button>
                        <a href="{{ route('admin.businessdirectory.jobs.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-gray-700 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-300 dark:hover:bg-gray-500 active:bg-gray-400 focus:outline-none focus:border-gray-400 focus:ring focus:ring-gray-300 disabled:opacity-25 transition">Reset</a>
                    </div>
                </div>
            </form>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700" id="jobs-table">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">ID</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Title</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Company</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Deadline</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse($jobs as $job)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-gray-100">{{ $job->id }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-gray-100">
                                        <a href="{{ route('admin.businessdirectory.jobs.show', $job->id) }}" class="hover:text-indigo-600 dark:hover:text-indigo-400">{{ $job->title }}</a>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">{{ $job->company->name ?? 'N/A' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                                        @php
                                            $statusClass = match($job->status) {
                                                'open' => 'bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100',
                                                'closed' => 'bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100',
                                                'filled' => 'bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100',
                                                'draft' => 'bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100',
                                                default => 'bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200',
                                            };
                                        @endphp
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusClass }}">
                                            {{ \Modules\BusinessDirectory\Entities\Job::getStatuses()[$job->status] ?? ucfirst($job->status) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">{{ $job->application_deadline ? $job->application_deadline->format('M d, Y') : 'N/A' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                        <a href="{{ route('admin.businessdirectory.jobs.show', $job->id) }}" class="text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-300" title="View"><i class="fas fa-eye"></i></a>
                                        <a href="{{ route('admin.businessdirectory.jobs.edit', $job->id) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300" title="Edit"><i class="fas fa-edit"></i></a>
                                        <form action="{{ route('admin.businessdirectory.jobs.destroy', $job->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this job?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300" title="Delete"><i class="fas fa-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300 text-center">No jobs found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
            </div>
            <div class="mt-6">
                {{ $jobs->appends(request()->query())->links() }} {{-- Ensure filters are appended to pagination links --}}
            </div>
                </div>
            </div>
        </div>
</div>
@stop

{{-- @push('js')
    // You can add any page-specific JS here if needed, but DataTables initialization is removed.
@endpush --}}