@extends('layouts.admin')

@section('title', 'Edit Job: ' . $job->title)

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Edit Job: <span class="font-normal">{{ $job->title }}</span></h1>
        <a href="{{ route('admin.businessdirectory.jobs.index') }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
            &larr; Back to Jobs
        </a>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    {{-- The form itself will be wrapped in its own card/bg in the partial --}}
    <form action="{{ route('admin.businessdirectory.jobs.update', $job->id) }}" method="POST" enctype="multipart/form-data"> {{-- Added enctype if jobs can have images/files --}}
        @method('PUT')
        {{-- Ensure all necessary variables are passed to the form partial --}}
        @include('businessdirectory::admin.jobs._form', ['job' => $job, 'companies' => $companies, 'categories' => $categories, 'job_types' => $job_types, 'job_statuses' => $job_statuses])
    </form>
</div>
@endsection