@extends('layouts.admin') {{-- Or your admin layout --}}

@section('title', 'Create New Job')

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Create New Job</h1>
        <a href="{{ route('admin.businessdirectory.jobs.index') }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
            &larr; Back to Jobs
        </a>
    </div>

    {{-- The form itself will be wrapped in its own card/bg in the partial --}}
    <form action="{{ route('admin.businessdirectory.jobs.store') }}" method="POST" enctype="multipart/form-data"> {{-- Added enctype if jobs can have images/files --}}
        @csrf
        {{-- Ensure all necessary variables are passed to the form partial --}}
        @include('businessdirectory::admin.jobs._form', ['job' => new \Modules\BusinessDirectory\Entities\Job(), 'companies' => $companies, 'categories' => $categories, 'job_types' => $job_types, 'job_statuses' => $job_statuses])
    </form>
</div>
@endsection