@csrf
<div class="p-6 space-y-6">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Name <span class="text-red-500">*</span></label>
        <input type="text" name="name" id="name" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('name') border-red-500 @enderror" value="{{ old('name', $companyType->name ?? '') }}" required>
        @error('name') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description</label>
        <textarea name="description" id="description" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('description') border-red-500 @enderror" rows="3">{{ old('description', $companyType->description ?? '') }}</textarea>
        @error('description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="icon_class" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Icon Class (e.g., fas fa-industry)</label>
        <input type="text" name="icon_class" id="icon_class" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('icon_class') border-red-500 @enderror" value="{{ old('icon_class', $companyType->icon_class ?? '') }}">
        @error('icon_class') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="icon_path" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Icon Image (SVG, PNG, JPG)</label>
        <input type="file" name="icon_path" id="icon_path" class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-300 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 dark:file:bg-gray-600 file:text-indigo-700 dark:file:text-indigo-300 hover:file:bg-indigo-100 dark:hover:file:bg-gray-500 @error('icon_path') border-red-500 @enderror">
        @error('icon_path') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
        @if(isset($companyType) && $companyType->icon_url)
            <div class="mt-2">
                <img src="{{ $companyType->icon_url }}" alt="Current Icon" class="h-16 w-auto rounded-md object-contain">
                <div class="mt-1 flex items-center">
                    <input type="checkbox" name="remove_icon_path" id="remove_icon_path" class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500" value="1">
                    <label for="remove_icon_path" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Remove icon image on save</label>
                </div>
            </div>
        @endif
    </div>

    <hr class="dark:border-gray-600">
    <h3 class="text-lg font-medium text-gray-900 dark:text-white">SEO Information (Optional)</h3>
     <div>
        <label for="meta_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Title</label>
        <input type="text" name="meta_title" id="meta_title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_title') border-red-500 @enderror" value="{{ old('meta_title', $companyType->meta_title ?? '') }}">
        @error('meta_title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="meta_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Description</label>
        <textarea name="meta_description" id="meta_description" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_description') border-red-500 @enderror" rows="2">{{ old('meta_description', $companyType->meta_description ?? '') }}</textarea>
        @error('meta_description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="meta_keywords" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Keywords (comma-separated)</label>
        <input type="text" name="meta_keywords" id="meta_keywords" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_keywords') border-red-500 @enderror" value="{{ old('meta_keywords', $companyType->meta_keywords ?? '') }}">
        @error('meta_keywords') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

</div>
<div class="px-6 py-4 bg-gray-50 dark:bg-gray-700 text-right space-x-3">
    <a href="{{ route('admin.businessdirectory.company-types.index') }}" class="inline-flex justify-center py-2 px-4 border border-gray-300 dark:border-gray-500 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-600 hover:bg-gray-50 dark:hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">Cancel</a>
    <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
        {{ isset($companyType) && $companyType->id ? 'Update Type' : 'Create Type' }}
    </button>
</div>

@push('scripts')
{{-- Add any specific JS for this form if needed --}}
@endpush