@extends('layouts.admin') {{-- Or your main admin layout --}}

@section('title', 'Create New Company')

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Create New Company</h1>
        <a href="{{ route('admin.businessdirectory.companies.index') }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
            &larr; Back to Companies
        </a>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
        <form action="{{ route('admin.businessdirectory.companies.store') }}" method="POST" enctype="multipart/form-data">
            @include('businessdirectory::admin.companies._form', ['company' => new \Modules\BusinessDirectory\Entities\Company(), 'users' => $users, 'companyTypes' => $companyTypes, 'categories' => $categories])
        </form>
    </div>
</div>
@endsection