@extends('layouts.admin') {{-- Or your main admin layout --}}

@section('title', 'Edit Category: ' . $category->name)

@section('content_header')
    <h1>Edit Category: <small>{{ $category->name }}</small></h1>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="max-w-3xl mx-auto">
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <form action="{{ route('admin.businessdirectory.categories.update', $category->id) }}" method="POST" enctype="multipart/form-data">
                @method('PUT')
                @include('businessdirectory::admin.categories._form', ['category' => $category, 'parentCategories' => $parentCategories])
            </form>
        </div>
    </div>
</div>
@endsection