<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Company;
use Modules\BusinessDirectory\Entities\Review;
use App\Entities\User; // Assuming global User model

class ReviewFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Review::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'company_id' => Company::factory(),
            'user_id' => User::factory(),
            'rating' => $this->faker->numberBetween(1, 5),
            'title' => $this->faker->optional()->sentence(5),
            'comment' => $this->faker->paragraph,
            'is_approved' => $this->faker->boolean(80), // 80% chance of being pre-approved
        ];
    }
}