<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Order;
use Modules\BusinessDirectory\Entities\OrderItem;
use Modules\BusinessDirectory\Entities\Product;

class OrderItemFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = OrderItem::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $product = Product::factory()->create();
        $quantity = $this->faker->numberBetween(1, 3);
        $pricePerUnit = $product->sale_price ?? $product->price;

        return [
            'order_id' => Order::factory(),
            'product_id' => $product->id,
            'quantity' => $quantity,
            'price_per_unit' => $pricePerUnit,
            'total_price' => $quantity * $pricePerUnit, // Model also calculates this
        ];
    }
}