<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Company;
use Modules\BusinessDirectory\Entities\Job;

class JobFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Job::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $jobTitle = $this->faker->jobTitle;
        return [
            'company_id' => Company::factory(),
            'title' => $jobTitle,
            // slug will be auto-generated
            'description' => $this->faker->paragraphs(5, true),
            'job_type' => $this->faker->randomElement(['full-time', 'part-time', 'contract', 'internship', 'temporary']),
            'location' => $this->faker->city . ', ' . $this->faker->stateAbbr,
            'salary_min' => $this->faker->optional(0.7)->numberBetween(30000, 80000),
            'salary_max' => $this->faker->optional(0.7)->numberBetween(80000, 150000),
            'currency' => 'USD',
            'experience_level' => $this->faker->randomElement(['entry-level', 'mid-level', 'senior-level', 'lead', 'manager']),
            'education_level' => $this->faker->optional()->randomElement(["Bachelor's Degree", "Master's Degree", "PhD", "High School Diploma", "Associate Degree"]),
            'skills_required' => $this->faker->randomElements(['PHP', 'Laravel', 'Vue.js', 'React', 'Node.js', 'Project Management', 'Communication', 'Teamwork'], $this->faker->numberBetween(2, 5)),
            'application_deadline' => $this->faker->dateTimeBetween('+1 week', '+3 months'),
            'status' => $this->faker->randomElement(['open', 'closed', 'filled']),
            'is_remote' => $this->faker->boolean(30), // 30% chance of being remote
            'views_count' => $this->faker->numberBetween(0, 2500),
        ];
    }
}