<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Job;
use Modules\BusinessDirectory\Entities\JobApplication;
use App\Entities\User; // Assuming global User model

class JobApplicationFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = JobApplication::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'job_id' => Job::factory(),
            'user_id' => User::factory(),
            'resume_path' => 'resumes/' . $this->faker->uuid . '.pdf', // Placeholder path
            'cover_letter' => $this->faker->optional(0.7)->paragraphs(3, true), // 70% chance of having a cover letter
            'status' => $this->faker->randomElement(['applied', 'shortlisted', 'interviewed', 'rejected', 'hired', 'withdrawn']),
            'applied_at' => $this->faker->dateTimeThisYear(),
        ];
    }
}