<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\CompanyType;

class CompanyTypeFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = CompanyType::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->unique()->randomElement(['Technology Solutions', 'Healthcare Services', 'Financial Consulting', 'Retail Goods', 'Manufacturing & Production', 'Creative Agency', 'Real Estate Development', 'Educational Institutions', 'Non-Profit Organization', 'Automotive Services', 'Logistics & Transport', 'Hospitality & Tourism']),
            // slug will be auto-generated by the HasSlug trait in the CompanyType model
            'description' => $this->faker->sentence(15),
            'icon' => $this->faker->optional()->randomElement(['fas fa-laptop-code', 'fas fa-heartbeat', 'fas fa-piggy-bank', 'fas fa-shopping-cart', 'fas fa-industry', 'fas fa-lightbulb', 'fas fa-building', 'fas fa-graduation-cap', 'fas fa-hands-helping', 'fas fa-car', 'fas fa-truck', 'fas fa-concierge-bell']),
        ];
    }
}
