<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\CompanyProject;
use Modules\BusinessDirectory\Entities\CompanyTask;
use App\Entities\User; // Assuming global User model

class CompanyTaskFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = CompanyTask::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $project = CompanyProject::factory()->create();
        return [
            'project_id' => $project->id,
            'title' => $this->faker->sentence(4),
            'description' => $this->faker->optional()->paragraph,
            'assignee_user_id' => $this->faker->optional(0.8)->randomElement(User::pluck('id')->toArray()) ?: null, // 80% chance of being assigned
            'due_date' => $this->faker->optional(0.7)->dateTimeBetween('now', '+3 months'),
            'priority' => $this->faker->randomElement(['low', 'medium', 'high', 'urgent']),
            'status' => $this->faker->randomElement(['todo', 'in_progress', 'review', 'completed', 'blocked']),
        ];
    }
}