<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Company;
use Modules\BusinessDirectory\Entities\CompanyType;
use App\Entities\User; // Assuming global User model

class CompanyFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Company::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $companyName = $this->faker->unique()->company;
        return [
            'user_id' => User::factory(),
            'company_type_id' => CompanyType::factory(),
            'name' => $companyName,
            // slug will be auto-generated by the HasSlug trait in the Company model
            'logo' => $this->faker->optional()->imageUrl(200, 200, 'business', true, 'logo'),
            'banner' => $this->faker->optional()->imageUrl(1200, 400, 'business', true, 'banner'),
            'description' => $this->faker->paragraphs(3, true),
            'address' => $this->faker->streetAddress,
            'city' => $this->faker->city,
            'state' => $this->faker->state,
            'zip_code' => $this->faker->postcode,
            'country' => $this->faker->country,
            'phone' => $this->faker->phoneNumber,
            'email' => $this->faker->unique()->companyEmail,
            'website' => $this->faker->optional()->url,
            'established_date' => $this->faker->optional()->date(),
            'employee_count' => $this->faker->optional()->randomElement(['1-10', '11-50', '51-200', '201-500', '500+']),
            'annual_revenue' => $this->faker->optional()->randomFloat(2, 10000, 10000000),
            'social_links' => $this->faker->optional()->randomElement([
                ['facebook' => 'https://facebook.com/' . $this->faker->userName, 'twitter' => 'https://twitter.com/' . $this->faker->userName, 'linkedin' => 'https://linkedin.com/company/' . $this->faker->slug],
                ['instagram' => 'https://instagram.com/' . $this->faker->userName, 'youtube' => 'https://youtube.com/channel/UC' . $this->faker->regexify('[A-Za-z0-9_-]{22}')],
                null
            ]),
            'meta_title' => $companyName . ' - Profile | ' . $this->faker->bs,
            'meta_description' => 'Learn more about ' . $companyName . ', a leading company in ' . ($this->faker->bs) . '. ' . $this->faker->sentence(10),
            'meta_keywords' => strtolower($companyName) . ', ' . $this->faker->bs . ', business directory, ' . $this->faker->word,
            'status' => $this->faker->randomElement(['pending', 'approved', 'rejected', 'suspended']),
            'is_featured' => $this->faker->boolean(15), // 15% chance of being featured
            'views_count' => $this->faker->numberBetween(0, 10000),
        ];
    }
}
