<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Cart;
use Modules\BusinessDirectory\Entities\CartItem;
use Modules\BusinessDirectory\Entities\Product;

class CartItemFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = CartItem::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $product = Product::factory()->create(); // Ensure product exists and get its price

        return [
            'cart_id' => Cart::factory(),
            'product_id' => $product->id,
            'quantity' => $this->faker->numberBetween(1, 5),
            'price_at_addition' => $product->sale_price ?? $product->price,
        ];
    }
}