<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Bid;
use Modules\BusinessDirectory\Entities\Tender;
use Modules\BusinessDirectory\Entities\Company;
use App\Entities\User; // Assuming global User model

class BidFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Bid::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'tender_id' => Tender::factory(),
            'company_id' => null, // Can be set explicitly or via a state
            'user_id' => User::factory(),
            'proposal' => $this->faker->paragraphs(3, true),
            'amount' => $this->faker->randomFloat(2, 100, 10000),
            'currency' => $this->faker->randomElement(['USD', 'EUR', 'GBP', 'KES']),
            'delivery_timeframe' => $this->faker->randomElement(['1 week', '2 weeks', '1 month', '6 weeks']),
            'attachments' => null, // Can be an array of file paths or URLs
            'status' => $this->faker->randomElement(['pending', 'accepted', 'rejected', 'withdrawn']),
            'is_flagged' => $this->faker->boolean(10), // 10% chance of being flagged
        ];
    }

    /**
     * Indicate that the bid is from a company.
     */
    public function fromCompany()
    {
        return $this->state(fn (array $attributes) => ['company_id' => Company::factory()]);
    }
}