# BusinessDirectory Module

## Description

The BusinessDirectory module provides a comprehensive platform for listing companies and their services. It aims to be a world-class company directory where users can discover businesses, and companies can showcase their offerings. Future enhancements will include job/tender listings, a bidding system, project management capabilities, and e-commerce functionality for listed companies.

## Current Features

- **Company Types Management (Admin):**
    - CRUD operations for defining different categories or types of businesses.
- **Company Listings Management (Admin):**
    - CRUD operations for adding, editing, and managing company profiles.
    - Fields include: name, description, logo, banner, contact details, address, geolocation (latitude/longitude), WhatsApp number, and status (pending, approved, etc.).
    - Ability to mark companies as "featured" or "e-commerce enabled".
- **Product Management (Admin - for E-commerce Companies):**
    - CRUD operations for managing products associated with e-commerce enabled companies.
    - Fields include: name, description, price, SKU, stock quantity, images, and published status.
- **Frontend Display:**
    - Public listing of company types.
    - Public listing of approved companies, filterable by type.
    - Individual company profile pages displaying details, logo, banner, contact information, and an integrated map (Leaflet.js).
    - WhatsApp chat integration on company profiles.

## inprogress
- must work with the landing page module,
- featured settings in admin
- Job/Tender posting and listing.
- Bidding system for tenders.
- Basic project management tools.
- Full e-commerce product display and potentially cart/checkout (depending on scope).
- Integration with the Subscription module to limit features based on user/company tiers.
- Advanced search and filtering for companies and services.
- User reviews and ratings for companies.
- Geo-fencing capabilities for location-based features.
- notifications with the existing notification feature
- show whatsapp widget dedicated to each listng
- other features to make this a complete world class moule for each function

## Installation / Setup

1.  Ensure the module is enabled in the main application's module management interface or `modules_statuses.json`.
2.  Run migrations: `php artisan module:migrate BusinessDirectory`
3.  Run seeders (to populate initial company types): `php artisan module:seed BusinessDirectory`
4.  Ensure the public storage link is set up: `php artisan storage:link` (for company logos, banners, and product images).

## Configuration

Currently, this module does not have specific publishable configuration files. Core settings are managed through the admin interface.

## Usage

- **Admin Panel:** Access the "Business Directory" section in the admin sidebar to manage Company Types and Company listings. Products can be managed via the "Manage Products" link on the company edit page or company listing row for e-commerce enabled companies.
- **Frontend:**
    - Navigate to `/company-types` to see all business categories.
    - Navigate to `/companies` to see all listed businesses.
    - Navigate to `/company/{slug}` to view a specific company's profile.