<?php

namespace Modules\BusinessDirectory\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'BusinessDirectory';
    /**
     * The module namespace to assume when generating URLs to actions.
     * @var string
     */
    protected string $moduleNamespace = 'Modules\BusinessDirectory\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapApiRoutes(); // The module's RSP handles API route prefixing and naming.
        $this->mapWebRoutes();
        $this->mapAdminRoutes();
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        Route::middleware('web')->group(module_path($this->name, '/routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapApiRoutes(): void
    {
        Route::middleware('api')->prefix('api')->name('api.')->group(module_path($this->name, '/routes/api.php'));
    }

    /**
     * Define the "admin" routes for the module.
     *
     * These routes are typically stateless.
     */
    protected function mapAdminRoutes(): void
    {
        Route::middleware(['web', \App\Http\Middleware\IsAdminMiddleware::class]) // Apply necessary middleware
             ->prefix('admin/' . strtolower($this->name)) // e.g., admin/businessdirectory
             ->as('admin.' . strtolower($this->name) . '.')     // e.g., admin.businessdirectory.
             ->namespace($this->moduleNamespace . '\\Admin')  // For Admin controllers
             ->group(module_path($this->name, '/routes/admin.php'));
    }
}
