<?php

namespace Modules\BusinessDirectory\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event handler mappings for the application.
     *
     * @var array<string, array<int, string>>
     */
protected $listen = [
    \Modules\BusinessDirectory\Events\NewJobApplicationSubmitted::class => [
        \Modules\BusinessDirectory\Listeners\SendNewJobApplicationNotification::class,
    ],
    \Modules\BusinessDirectory\Events\NewBidSubmitted::class => [
        \Modules\BusinessDirectory\Listeners\SendNewBidNotificationToTenderOwner::class,
    ],
    \Modules\BusinessDirectory\Events\BidSubmissionConfirmed::class => [
        \Modules\BusinessDirectory\Listeners\SendBidConfirmationToBidder::class,
    ],
    \Modules\BusinessDirectory\Events\BidWithdrawn::class => [
        \Modules\BusinessDirectory\Listeners\NotifyTenderOwnerOfBidWithdrawal::class,
    ],
    \Modules\BusinessDirectory\Events\NewReviewSubmittedForApproval::class => [
        \Modules\BusinessDirectory\Listeners\NotifyAdminOfNewReview::class,
    ],
    \Modules\BusinessDirectory\Events\NewTenderPosted::class => [
        \Modules\BusinessDirectory\Listeners\NotifyUsersOfNewTender::class,
    ],
    \Modules\BusinessDirectory\Events\TenderAwardedToAnotherBidder::class => [
        \Modules\BusinessDirectory\Listeners\NotifyLosingBiddersOfTenderAward::class,
    ],
    \Modules\BusinessDirectory\Events\BidStatusUpdated::class => [
        \Modules\BusinessDirectory\Listeners\NotifyBidderOfStatusChange::class,
    ],
    \Modules\BusinessDirectory\Events\CompanyTaskStatusUpdated::class => [
        \Modules\BusinessDirectory\Listeners\NotifyAssigneeOfTaskStatusChange::class,
    ],
];

    /**
     * Indicates if events should be discovered.
     *
     * @var bool
     */
    protected static $shouldDiscoverEvents = true;

    /**
     * Configure the proper event listeners for email verification.
     */
    protected function configureEmailVerification(): void {}
}
