<?php

namespace Modules\BusinessDirectory\Policies;

use App\Models\User;
use Modules\BusinessDirectory\Entities\Company;
use Modules\BusinessDirectory\Entities\CompanyProject;
use Illuminate\Auth\Access\HandlesAuthorization;

class CompanyProjectPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user, Company $company)
    {
        // Example: Allow if user owns the company
        return $user->id === $company->user_id;
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\BusinessDirectory\Entities\CompanyProject  $companyProject
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, CompanyProject $companyProject)
    {
        // Example: Allow if user owns the company the project belongs to
        return $user->id === $companyProject->company->user_id;
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\BusinessDirectory\Entities\Company  $company The company for which the project is being created
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user, Company $company)
    {
        // Example: Allow if user owns the company and company is approved
        return $user->id === $company->user_id && $company->status === 'approved';
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\BusinessDirectory\Entities\CompanyProject  $companyProject
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user, CompanyProject $companyProject)
    {
        // Example: Allow if user owns the company the project belongs to
        return $user->id === $companyProject->company->user_id;
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\BusinessDirectory\Entities\CompanyProject  $companyProject
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user, CompanyProject $companyProject)
    {
        // Example: Allow if user owns the company the project belongs to
        return $user->id === $companyProject->company->user_id;
    }

    /**
     * Determine whether the user can manage the model (e.g., add tasks, etc.).
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\BusinessDirectory\Entities\CompanyProject  $companyProject
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function manage(User $user, CompanyProject $companyProject)
    {
        // Example: Allow if user owns the company the project belongs to
        return $user->id === $companyProject->company->user_id;
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\BusinessDirectory\Entities\CompanyProject  $companyProject
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, CompanyProject $companyProject)
    {
        // return $user->id === $companyProject->company->user_id;
        return false; // Typically not needed for frontend
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \Modules\BusinessDirectory\Entities\CompanyProject  $companyProject
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, CompanyProject $companyProject)
    {
        // return $user->id === $companyProject->company->user_id;
        return false; // Typically not needed for frontend
    }
}