<?php

namespace Modules\BusinessDirectory\Policies;

use App\Models\User; // Assuming your User model path
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\BusinessDirectory\Entities\Bid;

class BidPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view the bid.
     */
    public function view(User $user, Bid $bid): bool
    {
        // User can view the bid if they submitted it directly
        if ($bid->bidder_user_id === $user->id) {
            return true;
        }

        // User can view the bid if they own the company that submitted it
        if ($bid->bidderCompany && $bid->bidderCompany->user_id === $user->id) {
             return true;
        }

        // User can view the bid if they own the company that posted the tender
        if ($bid->tender && $bid->tender->company && $bid->tender->company->user_id === $user->id) {
             return true;
        }

        return false;
    }

    /**
     * Determine whether the user can withdraw the bid.
     */
    public function withdraw(User $user, Bid $bid): bool
    {
        // User can withdraw the bid if they submitted it directly
        if ($bid->bidder_user_id === $user->id) {
            return true;
        }

        // User can withdraw the bid if they own the company that submitted it
        if ($bid->bidderCompany && $bid->bidderCompany->user_id === $user->id) {
             return true;
        }

        // Cannot withdraw if status is accepted, rejected, or already withdrawn
        if (in_array($bid->status, ['accepted', 'rejected', 'withdrawn'])) {
            return false;
        }

        // Cannot withdraw if tender is not open or deadline passed
         if ($bid->tender->status !== 'open' || ($bid->tender->deadline_for_bids && $bid->tender->deadline_for_bids->isPast())) {
            return false;
        }


        return false; // Default deny
    }

    // Add other policy methods like 'create', 'update', 'delete' if needed
}
