<?php

namespace Modules\BusinessDirectory\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Modules\BusinessDirectory\Events\NewBidSubmitted;
// use Modules\BusinessDirectory\Notifications\NotifyTenderOwnerOfNewBid; // Example Notification

class SendNewBidNotificationToTenderOwner // implements ShouldQueue
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(NewBidSubmitted $event): void
    {
        Log::info("New bid submitted for tender ID: {$event->bid->tender_id}. Bid ID: {$event->bid->id}");

        // Example: Notify the tender owner
        // $tenderOwner = $event->bid->tender->company->owner; // Assuming relationships
        // if ($tenderOwner) {
        //     $tenderOwner->notify(new NotifyTenderOwnerOfNewBid($event->bid));
        // }
    }
}