<?php

namespace Modules\BusinessDirectory\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Modules\BusinessDirectory\Events\BidSubmissionConfirmed;
// use Modules\BusinessDirectory\Notifications\BidSubmissionConfirmationNotification; // Example Notification

class SendBidConfirmationToBidder // implements ShouldQueue
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(BidSubmissionConfirmed $event): void
    {
        Log::info("Sending bid submission confirmation to user ID: {$event->bidder->id} for Bid ID: {$event->bid->id}");

        // Example: Notify the bidder
        // $event->bidder->notify(new BidSubmissionConfirmationNotification($event->bid));
    }
}