<?php

namespace Modules\BusinessDirectory\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Modules\BusinessDirectory\Events\CompanyTaskStatusUpdated;
// use Modules\BusinessDirectory\Notifications\TaskStatusChangedNotification; // Example Notification

class NotifyAssigneeOfTaskStatusChange // implements ShouldQueue // Uncomment if you want this listener to be queued
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  CompanyTaskStatusUpdated  $event
     * @return void
     */
    public function handle(CompanyTaskStatusUpdated $event)
    {
        Log::info("Task '{$event->task->title}' (ID: {$event->task->id}) status changed from '{$event->oldStatus}' to '{$event->newStatus}'.");

        if ($event->task->assignee) {
            Log::info("Notifying assignee: {$event->task->assignee->name} (ID: {$event->task->assignee_user_id})");
            // Example: Send notification to the assignee
            // $event->task->assignee->notify(new TaskStatusChangedNotification($event->task, $event->oldStatus, $event->newStatus));
        } else {
            Log::info("Task '{$event->task->title}' has no assignee. No notification sent.");
        }
    }
}