<?php

namespace Modules\BusinessDirectory\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Modules\BusinessDirectory\Entities\Tender;

class UpdateTenderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (!Auth::check()) {
            return false;
        }
        // Authorization to update a specific tender is handled by TenderPolicy in the controller.
        // $tender = $this->route('tender'); // Get the tender instance from the route
        // return $this->user()->can('update', $tender);
        return true; // Basic check, policy handles the rest.
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $tender = $this->route('tender'); // Get the tender instance for unique rule if needed

        return [
            'title' => 'required|string|max:255',
            // company_id is usually not updatable, or if it is, needs careful consideration
            'description' => 'required|string|max:10000',
            'requirements' => 'nullable|string|max:5000',
            'budget_min' => 'nullable|numeric|min:0',
            'budget_max' => 'nullable|numeric|min:0|gte:budget_min',
            'currency' => 'nullable|string|max:3',
            'deadline' => 'required|date', // 'after_or_equal:today' might be too strict for updates
            'type' => ['nullable', 'string', Rule::in(array_keys(Tender::getTenderTypes()))],
            'location' => 'nullable|string|max:255',
            'status' => ['sometimes', 'string', Rule::in(array_keys(Tender::getStatuses()))], // Allow status update
            'attachments' => 'nullable|array',
            'attachments.*' => [
                'file',
                'mimes:pdf,doc,docx,xls,xlsx,ppt,pptx,txt,jpg,jpeg,png,zip',
                'max:5120' // Max 5MB per file
            ],
        ];
    }
}