<?php

namespace Modules\BusinessDirectory\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Modules\BusinessDirectory\Entities\Job;

class UpdateJobRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     * The authorization logic is handled in the controller using a policy.
     */
    public function authorize(): bool
    {
        // Authorization is handled by the JobPolicy in the controller
        return Auth::check(); // Basic check that user is logged in
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'job_type' => 'nullable|string|max:50',
            'location' => 'nullable|string|max:255',
            'application_deadline' => 'nullable|date|after_or_equal:today', // Deadline should be today or in the future
            'status' => 'required|in:open,closed,filled,draft', // User can set more statuses on update
            'skills_required' => 'nullable|string',
            'is_remote' => 'boolean', // Added based on form
            'attachments' => 'nullable|array',
            'attachments.*' => [
                'file',
                'mimes:pdf,doc,docx,jpg,jpeg,png', // Adjust allowed types for jobs
                'max:2048' // Max 2MB per file for jobs (adjust as needed)
            ],
            // Add other fields like salary, experience_level if they are part of your form/db
        ];
    }

     /**
     * Prepare the data for validation.
     */
    protected function prepareForValidation(): void
    {
        // Ensure is_remote is a boolean
        $this->merge([
            'is_remote' => $this->has('is_remote'),
        ]);
    }
}