<?php

namespace Modules\BusinessDirectory\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Modules\BusinessDirectory\Entities\CompanyProject;

class UpdateCompanyProjectRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     * Authorization is handled by the CompanyProjectPolicy in the controller.
     */
    public function authorize(): bool
    {
        // The policy check is done in the controller's update method
        // $this->authorize('manage', $this->route('project'));
        return Auth::check(); // Basic check that user is logged in
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date|after_or_equal:start_date',
            'status' => ['required', 'string', Rule::in(['planning', 'in_progress', 'completed', 'on_hold', 'cancelled', 'draft'])],
            'team_id' => ['nullable', 'integer', Rule::exists('teams', 'id')->where(function ($query) {
                $query->where('user_id', Auth::id()); // Ensure the team is owned by the current user
            })],
        ];
    }
}