<?php

namespace Modules\BusinessDirectory\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Modules\BusinessDirectory\Entities\Company;

class StoreJobRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     * The authorization logic is handled in the controller using a policy,
     * but we can add a basic check here.
     */
    public function authorize(): bool
    {
        // User must be authenticated
        if (!Auth::check()) {
            return false;
        }
        // Further authorization (e.g., user owns the company) is in the controller
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'job_type' => 'nullable|string|max:50',
            'location' => 'nullable|string|max:255',
            'application_deadline' => 'nullable|date|after_or_equal:today', // Deadline should be today or in the future
            'status' => 'required|in:open,draft', // User can only set these initially
            'skills_required' => 'nullable|string',
            'is_remote' => 'boolean', // Added based on form
            'attachments' => 'nullable|array',
            'attachments.*' => [
                'file',
                'mimes:pdf,doc,docx,jpg,jpeg,png', // Adjust allowed types for jobs
                'max:2048' // Max 2MB per file for jobs (adjust as needed)
            ],
            // Add other fields like salary, experience_level if they are part of your form/db
        ];
    }

    /**
     * Prepare the data for validation.
     */
    protected function prepareForValidation(): void
    {
        // Ensure is_remote is a boolean
        $this->merge([
            'is_remote' => $this->has('is_remote'),
        ]);
    }
}