<?php
namespace Modules\BusinessDirectory\Http\Requests\Admin;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class StoreCategoryRequest extends FormRequest
{
    public function authorize(): bool { return Auth::check() && Auth::user()->isAdmin(); }
    public function rules(): array {
        return [
            'name' => ['required', 'string', 'max:255', Rule::unique('bd_categories', 'name')],
            'description' => 'nullable|string|max:1000',
            'parent_id' => 'nullable|exists:bd_categories,id',
            'icon_class' => 'nullable|string|max:100',
            'image_path' => ['nullable', 'image', 'mimes:jpg,jpeg,png,svg,webp', 'max:1024'],
            'is_featured' => 'nullable|boolean',
        ];
    }
    protected function prepareForValidation() { $this->merge(['is_featured' => $this->boolean('is_featured')]); }
}
