<?php

namespace Modules\BusinessDirectory\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\BusinessDirectory\Entities\Company;
use Modules\BusinessDirectory\Entities\Tender;
use Modules\BusinessDirectory\Entities\Product;

class DashboardController extends Controller
{
    /**
     * Display the admin dashboard for the BusinessDirectory module.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $companyCount = Company::count();
        $activeTenderCount = Tender::where('status', 'open')->count(); // Example: only open tenders
        $productCount = Product::count();

        return view('businessdirectory::admin.dashboard', compact(
            'companyCount',
            'activeTenderCount',
            'productCount'
        ));
    }
}
