<?php

namespace Modules\BusinessDirectory\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Modules\BusinessDirectory\Entities\JobApplication;

class NewJobApplicationSubmitted
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public JobApplication $application;

    /**
     * Create a new event instance.
     *
     * @param JobApplication $application
     */
    public function __construct(JobApplication $application)
    {
        $this->application = $application;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        // Example: return new PrivateChannel('channel-name');
        // Or return []; if no broadcasting is needed.
        return [];
    }
}