<?php

namespace Modules\BusinessDirectory\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Modules\BusinessDirectory\Entities\CompanyTask;

class CompanyTaskStatusUpdated
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public CompanyTask $task;
    public string $oldStatus;
    public string $newStatus;

    /**
     * Create a new event instance.
     *
     * @param CompanyTask $task
     * @param string $oldStatus
     * @param string $newStatus
     * @return void
     */
    public function __construct(CompanyTask $task, string $oldStatus, string $newStatus)
    {
        $this->task = $task;
        $this->oldStatus = $oldStatus;
        $this->newStatus = $newStatus;
    }

    /**
     * Get the channels the event should be broadcast on.
     */
    // public function broadcastOn(): array
    // {
    //     return [];
    // }
}