<?php

namespace Modules\BusinessDirectory\Events;

use App\Models\User; // Assuming your User model path
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Modules\BusinessDirectory\Entities\Bid;

class BidSubmissionConfirmed
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Bid $bid;
    public User $bidder;

    /**
     * Create a new event instance.
     *
     * @param Bid $bid
     * @param User $bidder
     */
    public function __construct(Bid $bid, User $bidder)
    {
        $this->bid = $bid;
        $this->bidder = $bidder;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array
     */
    public function broadcastOn(): array
    {
        return [];
    }
}