<?php

namespace Modules\BusinessDirectory\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Modules\BusinessDirectory\Entities\Bid;

class BidStatusUpdated
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Bid $bid;
    public string $newStatus;

    /**
     * Create a new event instance.
     *
     * @param Bid $bid
     * @param string $newStatus
     */
    public function __construct(Bid $bid, string $newStatus)
    {
        $this->bid = $bid;
        $this->newStatus = $newStatus;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array
     */
    public function broadcastOn(): array
    {
        return [];
    }
}