<?php

namespace Modules\BusinessDirectory\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User; // Standardized User model path

class CompanyTask extends Model
{
    use HasFactory;

    protected $table = 'bd_tasks';

    protected $fillable = [
        'project_id',
        'title',
        'user_id',
        'description',
        'assignee_user_id',
        'due_date',
        'priority', // e.g., low, medium, high
        'status', // e.g., todo, in_progress, completed, blocked
    ];

    protected $casts = [
        'due_date' => 'date',
    ];

    /**
     * Get the project this task belongs to.
     */
    public function project(): BelongsTo
    {
        return $this->belongsTo(CompanyProject::class, 'project_id');
    }

    /**
     * Get the user assigned to this task.
     */
    public function assignee(): BelongsTo
    {
        return $this->belongsTo(User::class, 'assignee_user_id');
    }

    /**
     * Factory
     */
    protected static function newFactory()
    {
        return \Modules\BusinessDirectory\Database\factories\CompanyTaskFactory::new();
    }

    /**
     * Get the defined statuses for a task.
     *
     * @return array
     */
    public static function getStatuses(): array
    {
        return [
            'todo' => 'To Do',
            'in_progress' => 'In Progress',
            'review' => 'Review',
            'completed' => 'Completed',
            'blocked' => 'Blocked',
        ];
    }

    /**
     * Get the defined priorities for a task.
     *
     * @return array
     */
    public static function getPriorities(): array
    {
        return [
            'low' => 'Low',
            'medium' => 'Medium',
            'high' => 'High',
            'urgent' => 'Urgent',
        ];
    }
}
