<?php

use Illuminate\Support\Facades\Route;
use Modules\AuthorizeNetGateway\Http\Controllers\Admin\AuthorizeNetConfigController;
use App\Http\Middleware\IsAdminMiddleware;

// The main app/Providers/RouteServiceProvider.php applies 'admin/authorizenetgateway/' prefix
// and 'admin.authorizenetgateway.' name prefix.
Route::middleware(['web', IsAdminMiddleware::class])
    ->group(function () {
        Route::get('settings', [AuthorizeNetConfigController::class, 'edit'])->name('settings.edit');
        Route::put('settings', [AuthorizeNetConfigController::class, 'update'])->name('settings.update');
    });