@extends('layouts.admin') {{-- Or your AppManager specific admin layout --}}

@section('title', 'Script Details: ' . $script->name)
@section('header_title', 'Script Details: ' . $script->name)

@section('content')
<div class="container px-6 mx-auto grid">
    <div class="my-6">
        <div class="flex justify-between items-center mb-4">
            <a href="{{ route('admin.appmanager.scripts.index') }}" class="text-purple-600 hover:text-purple-800 dark:text-purple-400 dark:hover:text-purple-200">
                &larr; Back to All Scripts
            </a>
            <div>
                <a href="{{ route('admin.appmanager.scripts.edit', $script) }}" class="px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">
                    Edit Script
                </a>
                <a href="{{ route('admin.appmanager.scripts.files.index', $script) }}" class="ml-2 px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-blue-500 border border-transparent rounded-lg active:bg-blue-600 hover:bg-blue-700 focus:outline-none focus:shadow-outline-blue">
                    Manage Files
                </a>
            </div>
        </div>

        <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
            <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200 mb-2">{{ $script->name }}</h2>
            <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">Slug: {{ $script->slug }}</p>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-1">Details</h3>
                    <dl class="divide-y divide-gray-200 dark:divide-gray-700">
                        <div class="py-3 sm:grid sm:grid-cols-3 sm:gap-4">
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Current Version</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 sm:mt-0 sm:col-span-2">{{ $script->current_version ?: 'N/A' }}</dd>
                        </div>
                        <div class="py-3 sm:grid sm:grid-cols-3 sm:gap-4">
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Status</dt>
                            <dd class="mt-1 text-sm sm:mt-0 sm:col-span-2">
                                <span class="px-2 py-1 font-semibold leading-tight
                                    @if($script->status == 'active') text-green-700 bg-green-100 dark:bg-green-700 dark:text-green-100
                                    @elseif($script->status == 'development') text-blue-700 bg-blue-100 dark:bg-blue-700 dark:text-blue-100
                                    @elseif($script->status == 'beta') text-yellow-700 bg-yellow-100 dark:bg-yellow-700 dark:text-yellow-100
                                    @elseif($script->status == 'deprecated') text-orange-700 bg-orange-100 dark:bg-orange-700 dark:text-orange-100
                                    @elseif($script->status == 'archived') text-gray-700 bg-gray-100 dark:text-gray-100 dark:bg-gray-700
                                    @else text-gray-700 bg-gray-100 dark:text-gray-100 dark:bg-gray-700 @endif
                                    rounded-full">
                                    {{ ucfirst($script->status) }}
                                </span>
                            </dd>
                        </div>
                        <div class="py-3 sm:grid sm:grid-cols-3 sm:gap-4">
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Boilerplate Core</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 sm:mt-0 sm:col-span-2">{{ $script->is_boilerplate_core ? 'Yes' : 'No' }}</dd>
                        </div>
                        <div class="py-3 sm:grid sm:grid-cols-3 sm:gap-4">
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Envato Item ID</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 sm:mt-0 sm:col-span-2">{{ $script->envato_item_id ?: 'N/A' }}</dd>
                        </div>
                        <div class="py-3 sm:grid sm:grid-cols-3 sm:gap-4">
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Created At</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 sm:mt-0 sm:col-span-2">{{ $script->created_at->format('M d, Y H:i A') }}</dd>
                        </div>
                        <div class="py-3 sm:grid sm:grid-cols-3 sm:gap-4">
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Last Updated</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 sm:mt-0 sm:col-span-2">{{ $script->updated_at->format('M d, Y H:i A') }}</dd>
                        </div>
                    </dl>
                </div>
                <div>
                    <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-1">Description</h3>
                    <div class="prose prose-sm dark:prose-invert max-w-none p-3 bg-gray-50 dark:bg-gray-700 rounded-md">
                        {!! $script->description ? nl2br(e($script->description)) : '<p class="italic text-gray-500 dark:text-gray-400">No description provided.</p>' !!}
                    </div>
                </div>
            </div>

            <div>
                <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-2">Changelog</h3>
                <div class="prose prose-sm dark:prose-invert max-w-none p-4 bg-gray-50 dark:bg-gray-700 rounded-md h-64 overflow-y-auto border dark:border-gray-600">
                    @if($script->changelog)
                        {!! \Illuminate\Support\Str::markdown(e($script->changelog)) !!}
                    @else
                        <p class="italic text-gray-500 dark:text-gray-400">No changelog provided.</p>
                    @endif
                </div>
            </div>

            <div class="mt-6">
                <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-2">Associated Licenses</h3>
                @if($script->licenses()->count() > 0)
                    <a href="{{ route('admin.appmanager.licenses.index', ['managed_script_id' => $script->id]) }}" class="text-purple-600 hover:underline dark:text-purple-400">
                        View {{ $script->licenses()->count() }} License(s)
                    </a>
                @else
                    <p class="text-sm text-gray-500 dark:text-gray-400">No licenses associated with this script yet.</p>
                    <a href="{{ route('admin.appmanager.licenses.create', ['managed_script_id' => $script->id]) }}" class="mt-2 inline-block px-3 py-1 text-xs font-medium leading-5 text-white transition-colors duration-150 bg-green-500 border border-transparent rounded-md active:bg-green-600 hover:bg-green-600 focus:outline-none focus:shadow-outline-green">
                        Create First License
                    </a>
                @endif
            </div>

        </div>
    </div>
</div>
@endsection