<div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div>
        <label for="managed_script_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Managed Script <span class="text-red-500">*</span></label>
        <select name="managed_script_id" id="managed_script_id" required
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
            <option value="">Select Script</option>
            @foreach($scripts as $id => $name)
                <option value="{{ $id }}" {{ old('managed_script_id', $license->managed_script_id ?? request('managed_script_id')) == $id ? 'selected' : '' }}>{{ $name }}</option>
            @endforeach
        </select>
        @error('managed_script_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="license_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">License Key</label>
        <input type="text" name="license_key" id="license_key" value="{{ old('license_key', $license->license_key ?? '') }}"
               placeholder="Leave blank if auto-generating"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('license_key') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div class="md:col-span-2">
        <label for="auto_generate_key" class="flex items-center text-sm font-medium text-gray-700 dark:text-gray-300 cursor-pointer">
            <input type="checkbox" name="auto_generate_key" id="auto_generate_key" value="1"
                   class="rounded border-gray-300 text-purple-600 shadow-sm focus:border-purple-300 focus:ring focus:ring-purple-200 focus:ring-opacity-50 dark:bg-gray-700 dark:border-gray-600"
                   @if(old('auto_generate_key', !isset($license) || empty($license->license_key) )) checked @endif
                   onchange="toggleLicenseKeyInput(this.checked)">
            <span class="ml-2">Auto-generate license key</span>
        </label>
        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">If checked, the license key field above will be ignored and a unique key generated.</p>
    </div>


    <div>
        <label for="type" class="block text-sm font-medium text-gray-700 dark:text-gray-300">License Type <span class="text-red-500">*</span></label>
        <select name="type" id="type" required
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
            @foreach($types as $key => $value)
                <option value="{{ $key }}" {{ old('type', $license->type ?? 'internal') == $key ? 'selected' : '' }}>{{ $value }}</option>
            @endforeach
        </select>
        @error('type') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="purchase_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Purchase Code (e.g., CodeCanyon)</label>
        <input type="text" name="purchase_code" id="purchase_code" value="{{ old('purchase_code', $license->purchase_code ?? '') }}"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('purchase_code') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="customer_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Customer Name</label>
        <input type="text" name="customer_name" id="customer_name" value="{{ old('customer_name', $license->customer_name ?? '') }}"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('customer_name') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="customer_email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Customer Email</label>
        <input type="email" name="customer_email" id="customer_email" value="{{ old('customer_email', $license->customer_email ?? '') }}"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('customer_email') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="activation_limit" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Activation Limit <span class="text-red-500">*</span></label>
        <input type="number" name="activation_limit" id="activation_limit" value="{{ old('activation_limit', $license->activation_limit ?? 1) }}" required min="0"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Set to 0 for unlimited activations.</p>
        @error('activation_limit') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
        <select name="status" id="status" required
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
            @foreach($statuses as $key => $value)
                <option value="{{ $key }}" {{ old('status', $license->status ?? 'pending') == $key ? 'selected' : '' }}>{{ $value }}</option>
            @endforeach
        </select>
        @error('status') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="expires_at" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Expires At</label>
        <input type="date" name="expires_at" id="expires_at" value="{{ old('expires_at', isset($license->expires_at) ? $license->expires_at->format('Y-m-d') : '') }}"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('expires_at') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div class="md:col-start-1"> {{-- Ensure this checkbox is on a new line or positioned logically --}}
        <label for="does_not_expire" class="flex items-center text-sm font-medium text-gray-700 dark:text-gray-300 cursor-pointer mt-2">
            <input type="checkbox" name="does_not_expire" id="does_not_expire" value="1"
                   class="rounded border-gray-300 text-purple-600 shadow-sm focus:border-purple-300 focus:ring focus:ring-purple-200 focus:ring-opacity-50 dark:bg-gray-700 dark:border-gray-600"
                   @if(old('does_not_expire', isset($license) && is_null($license->expires_at) && $license->exists)) checked @endif
                   onchange="toggleExpiresAtInput(this.checked)">
            <span class="ml-2">License does not expire</span>
        </label>
    </div>


    <div>
        <label for="supported_until" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Support Valid Until</label>
        <input type="date" name="supported_until" id="supported_until" value="{{ old('supported_until', isset($license->supported_until) ? $license->supported_until->format('Y-m-d') : '') }}"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('supported_until') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div class="md:col-span-2">
        <label for="metadata" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Metadata (JSON)</label>
        <textarea name="metadata" id="metadata" rows="3" placeholder='{"feature_x_enabled": true, "max_users": 10}'
                  class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">{{ old('metadata', isset($license->metadata) ? json_encode($license->metadata, JSON_PRETTY_PRINT) : '') }}</textarea>
        @error('metadata') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div class="md:col-span-2">
        <label for="notes" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Internal Notes</label>
        <textarea name="notes" id="notes" rows="3"
                  class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">{{ old('notes', $license->notes ?? '') }}</textarea>
        @error('notes') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>
</div>

<div class="mt-8 flex justify-end">
    <a href="{{ route('admin.appmanager.licenses.index', ['managed_script_id' => request('managed_script_id', $license->managed_script_id ?? null)]) }}" class="mr-3 inline-flex items-center px-4 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-500 rounded-md font-semibold text-xs text-gray-700 dark:text-gray-300 uppercase tracking-widest shadow-sm hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 disabled:opacity-25 transition ease-in-out duration-150">
        Cancel
    </a>
    <button type="submit" class="inline-flex items-center px-4 py-2 bg-purple-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-purple-700 active:bg-purple-900 focus:outline-none focus:border-purple-900 focus:ring ring-purple-300 disabled:opacity-25 transition ease-in-out duration-150">
        {{ isset($license) && $license->exists ? 'Update License' : 'Create License' }}
    </button>
</div>

@pushOnce('scripts')
<script>
    function toggleExpiresAtInput(doesNotExpire) {
        const expiresAtInput = document.getElementById('expires_at');
        if (expiresAtInput) {
            if (doesNotExpire) {
                expiresAtInput.disabled = true;
                expiresAtInput.value = ''; // Clear value if it doesn't expire
            } else {
                expiresAtInput.disabled = false;
            }
        }
    }

    function toggleLicenseKeyInput(autoGenerate) {
        const licenseKeyInput = document.getElementById('license_key');
        if (licenseKeyInput) {
            licenseKeyInput.disabled = autoGenerate;
            // The 'required' attribute is tricky with JS if the field is sometimes not submitted.
            // Server-side validation should handle if it's required when not auto-generating.
            // licenseKeyInput.required = !autoGenerate;
            if (autoGenerate) {
                licenseKeyInput.value = ''; // Clear if auto-generating
                licenseKeyInput.placeholder = 'Will be auto-generated';
            } else {
                 licenseKeyInput.placeholder = 'Enter license key manually';
            }
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        const doesNotExpireCheckbox = document.getElementById('does_not_expire');
        if (doesNotExpireCheckbox) {
            toggleExpiresAtInput(doesNotExpireCheckbox.checked);
        }

        const autoGenerateKeyCheckbox = document.getElementById('auto_generate_key');
        if (autoGenerateKeyCheckbox) {
            toggleLicenseKeyInput(autoGenerateKeyCheckbox.checked);
        }
    });
</script>
@endPushOnce
