@extends('layouts.admin')

@section('title', 'Manage Scripts')
@section('header_title', 'Manage Scripts & Applications')

@section('content')
<div class="mb-4 flex justify-between items-center">
    <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200">Scripts / Modules</h2>
    <a href="{{ route('admin.appmanager.scripts.create') }}" class="px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">
        Add New Script
    </a>
</div>

@include('admin.partials.alerts')

<!-- Search Form -->
<div class="mb-4">
    <form method="GET" action="{{ route('admin.appmanager.scripts.index') }}">
        <div class="flex">
            <input type="text" name="search" placeholder="Search scripts..." value="{{ request('search') }}"
                   class="block w-full md:w-1/2 lg:w-1/3 px-4 py-2 text-sm text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-l-md focus:border-purple-400 focus:ring focus:ring-purple-200 focus:ring-opacity-50">
            <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-r-md hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800">
                Search
            </button>
        </div>
    </form>
</div>

<div class="w-full overflow-hidden rounded-lg shadow-xs">
    <div class="w-full overflow-x-auto">
        <table class="w-full whitespace-no-wrap">
            <thead>
                <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                    <th class="px-4 py-3">Name</th>
                    <th class="px-4 py-3">Slug</th>
                    <th class="px-4 py-3">Version</th>
                    <th class="px-4 py-3">Status</th>
                    <th class="px-4 py-3">Boilerplate Core</th>
                    <th class="px-4 py-3">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                @forelse ($scripts as $script)
                <tr class="text-gray-700 dark:text-gray-400">
                    <td class="px-4 py-3 text-sm font-semibold">{{ $script->name }}</td>
                    <td class="px-4 py-3 text-sm">{{ $script->slug }}</td>
                    <td class="px-4 py-3 text-sm">{{ $script->current_version }}</td>
                    <td class="px-4 py-3 text-xs">
                        <span class="px-2 py-1 font-semibold leading-tight
                            @if($script->status == 'active') text-green-700 bg-green-100 dark:bg-green-700 dark:text-green-100
                            @elseif($script->status == 'development') text-blue-700 bg-blue-100 dark:bg-blue-700 dark:text-blue-100
                            @elseif($script->status == 'beta') text-yellow-700 bg-yellow-100 dark:bg-yellow-700 dark:text-yellow-100
                            @else text-gray-700 bg-gray-100 dark:text-gray-100 dark:bg-gray-700 @endif
                            rounded-full">
                            {{ ucfirst($script->status) }}
                        </span>
                    </td>
                    <td class="px-4 py-3 text-sm">
                        {{ $script->is_boilerplate_core ? 'Yes' : 'No' }}
                    </td>
                    <td class="px-4 py-3">
                        <div class="flex items-center space-x-2 text-sm">
                            <a href="{{ route('admin.appmanager.scripts.files.index', $script) }}" class="text-xs px-2 py-1 font-medium leading-5 text-white transition-colors duration-150 bg-blue-500 border border-transparent rounded-md active:bg-blue-600 hover:bg-blue-700 focus:outline-none focus:shadow-outline-blue" title="Manage Files">
                                Files
                            </a>
                            <a href="{{ route('admin.appmanager.scripts.edit', $script) }}" class="flex items-center justify-between px-2 py-2 text-sm font-medium leading-5 text-purple-600 rounded-lg dark:text-gray-400 focus:outline-none focus:shadow-outline-gray" aria-label="Edit">
                                <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20"><path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"></path></svg>
                            </a>
                            <form action="{{ route('admin.appmanager.scripts.destroy', $script) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this script? This might affect associated licenses and files.');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="flex items-center justify-between px-2 py-2 text-sm font-medium leading-5 text-purple-600 rounded-lg dark:text-gray-400 focus:outline-none focus:shadow-outline-gray" aria-label="Delete">
                                    <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd"></path></svg>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-4 py-3 text-center text-sm text-gray-500 dark:text-gray-400">No managed scripts found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="px-4 py-3">
        {{ $scripts->links() }}
    </div>
</div>
@endsection
