@extends('layouts.admin')

@section('title', 'Activation Logs')
@section('header_title', 'Script Activation Logs')

@section('content')
<div class="mb-4 flex justify-between items-center">
    <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200">Activation Logs</h2>
</div>

@include('admin.partials.alerts')

<!-- Search and Filter Form -->
<div class="mb-6 p-4 bg-white dark:bg-gray-800 rounded-lg shadow">
    <form method="GET" action="{{ route('admin.appmanager.activationlogs.index') }}">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Search (Domain, IP, Key, Email)</label>
                <input type="text" name="search" id="search" placeholder="Enter search term..." value="{{ request('search') }}"
                       class="mt-1 block w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md focus:border-purple-400 focus:ring focus:ring-purple-200 focus:ring-opacity-50">
            </div>
            <div>
                <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                <select name="status" id="status" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                    <option value="all" {{ request('status') == 'all' ? 'selected' : '' }}>All Statuses</option>
                    @foreach($statuses as $key => $value)
                        <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $value }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-md hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800">
                    Filter
                </button>
                 <a href="{{ route('admin.appmanager.activationlogs.index') }}" class="ml-2 px-4 py-2 text-sm font-medium text-gray-700 dark:text-gray-300 bg-gray-200 dark:bg-gray-600 rounded-md hover:bg-gray-300 dark:hover:bg-gray-500">
                    Clear
                </a>
            </div>
        </div>
    </form>
</div>


<div class="w-full overflow-hidden rounded-lg shadow-xs">
    <div class="w-full overflow-x-auto">
        <table class="w-full whitespace-no-wrap">
            <thead>
                <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                    <th class="px-4 py-3">Script</th>
                    <th class="px-4 py-3">License Key</th>
                    <th class="px-4 py-3">Domain</th>
                    <th class="px-4 py-3">IP Address</th>
                    <th class="px-4 py-3">Status</th>
                    <th class="px-4 py-3">Message</th>
                    <th class="px-4 py-3">Date</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                @forelse ($logs as $log)
                <tr class="text-gray-700 dark:text-gray-400">
                    <td class="px-4 py-3 text-sm">{{ $log->license->managedScript->name ?? 'N/A' }}</td>
                    <td class="px-4 py-3 text-sm">{{ $log->license->license_key ?? 'N/A' }}</td>
                    <td class="px-4 py-3 text-sm">{{ $log->activated_domain ?: '-' }}</td>
                    <td class="px-4 py-3 text-sm">{{ $log->ip_address ?: '-' }}</td>
                    <td class="px-4 py-3 text-xs">
                        <span class="px-2 py-1 font-semibold leading-tight
                            @if($log->status == 'success') text-green-700 bg-green-100 dark:bg-green-700 dark:text-green-100
                            @else text-red-700 bg-red-100 dark:text-red-100 dark:bg-red-700 @endif
                            rounded-full">
                            {{ ucfirst(str_replace('_', ' ', $log->status)) }}
                        </span>
                    </td>
                    <td class="px-4 py-3 text-sm truncate max-w-xs" title="{{ $log->message }}">{{ Str::limit($log->message, 50) ?: '-' }}</td>
                    <td class="px-4 py-3 text-sm">{{ $log->activated_at->format('M d, Y H:i') }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-4 py-3 text-center text-sm text-gray-500 dark:text-gray-400">No activation logs found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="px-4 py-3">
        {{ $logs->links() }}
    </div>
</div>
@endsection
