<?php

namespace Modules\AppManager\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ActivationLog extends Model
{
    use HasFactory;

    protected $table = 'am_activation_logs';

    public $timestamps = false; // We only have 'activated_at'

    protected $fillable = [
        'license_id',
        'activated_domain',
        'ip_address',
        'server_signature',
        'status',
        'message',
        'activated_at',
    ];

    protected $casts = [
        'activated_at' => 'datetime',
    ];

    public function license(): BelongsTo
    {
        return $this->belongsTo(License::class);
    }
}