# AppManager Module

## Description

The AppManager module is designed to manage external scripts or applications, providing licensing, activation, and secure file download capabilities. It allows administrators to define scripts, generate license keys, track activations, and provide versioned, downloadable files to licensed users.

## Features

- Script Management: Define and manage details of scripts/applications.
- License Key Generation: Create and manage license keys for scripts.
- Activation Tracking: Monitor license activations, including domain, IP, and other metadata.
- Secure File Downloads: Provide versioned file downloads accessible via expiring tokens linked to valid licenses.
- Boilerplate Core Identification: Flag core boilerplate scripts that might have different licensing or update rules.

## Installation / Setup

1.  Ensure the module is enabled in the main application's module management interface or `modules_statuses.json`.
2.  Run migrations: `php artisan module:migrate AppManager`
3.  Run seeders (if any): `php artisan module:seed AppManager`
4.  Ensure the public storage link is set up: `php artisan storage:link` (as downloadable files are stored in `storage/app/public/downloadable_files` by default).
5.  Configure file upload limits in your `php.ini` if you plan to upload large script files.

## Configuration

Key configuration options for this module can be found in `config/appmanager.php` (after publishing `php artisan vendor:publish --tag=appmanager-config` if you set up a publishable config).

- `download_token_duration_minutes`: Default duration for how long a download token is valid (e.g., 60 minutes).
- `download_token_max_uses`: Default maximum number of times a single download token can be used.

## API Endpoints

This module exposes API endpoints for external scripts to interact with:

- **POST `/api/appmanager/activate`**: For activating a license.
- **POST `/api/appmanager/validate-license`**: For periodic validation of an existing activation/license.
- **POST `/api/appmanager/download-file`**: For requesting a secure download link for a script file.

Refer to the `Modules/AppManager/Routes/api.php` file for detailed request parameters.

## Implementing Licensing in Your Script (Client-Side Script)

To integrate a script (e.g., a PHP application, a WordPress plugin) with the AppManager module for licensing and updates, you'll typically need to implement the following logic within that external script:

### 1. Activation Process

When the user of your script first installs or needs to activate it:

*   **Collect License Key:** Prompt the user to enter their license key (obtained from your main application where AppManager is installed).
*   **Collect Activation Data:** Gather necessary data for activation. This might include:
    *   `domain`: The domain where the script is being installed (e.g., `$_SERVER['HTTP_HOST']`).
    *   `script_slug`: The unique slug of the script being activated (this must match a `ManagedScript` slug in AppManager).
    *   `ip_address` (optional): `$_SERVER['SERVER_ADDR']` or user's IP.
    *   `version` (optional): Current version of the script being activated.
    *   Any other `metadata` you wish to store (e.g., PHP version, server software).
*   **Make API Request:** Send a POST request from your script to the AppManager's activation endpoint:
    `POST YOUR_APP_URL/api/appmanager/activate`
    **Request Body (JSON):**
    ```json
    {
        "license_key": "USER_ENTERED_LICENSE_KEY",
        "script_slug": "your_script_slug",
        "domain": "customer-domain.com",
        "ip_address": "123.123.123.123",
        "version": "1.0.0",
        "metadata": { "php_version": "8.1" }
    }
    ```
*   **Handle Response:**
    *   **Success (e.g., 200 OK):** The API will return data including an `activation_token` and potentially other license details. Store this `activation_token` securely in your script's settings. This token might be needed for future validation or updates.
    *   **Failure (e.g., 4xx, 5xx):** The API will return an error message (e.g., invalid license, limit reached). Display an appropriate message to the user.

### 2. License Validation (Periodic Checks)

Periodically (e.g., weekly, or on certain admin page loads in your script), your script should validate its activation:

*   **Make API Request:** Send a POST request from your script to:
    `POST YOUR_APP_URL/api/appmanager/validate-license`
    **Request Body (JSON):**
    ```json
    {
        "license_key": "STORED_LICENSE_KEY",
        "activation_token": "STORED_ACTIVATION_TOKEN", // The token received during successful activation
        "script_slug": "your_script_slug",
        "domain": "customer-domain.com" // Current domain for verification
    }
    ```
*   **Handle Response:**
    *   **Success (e.g., 200 OK, `{"valid": true}`):** License is still valid.
    *   **Failure (e.g., 200 OK, `{"valid": false, "message": "..."}` or 4xx error):** License is invalid, expired, or activation token doesn't match. Your script should then take appropriate action (e.g., display a notice, restrict functionality).

### 3. Secure File Downloads (Updates)

When your script needs to check for updates or download a new version:

*   **Make API Request (to get a download token):**
    `POST YOUR_APP_URL/api/appmanager/download-file`
    **Request Body (JSON):**
    ```json
    {
        "license_key": "STORED_LICENSE_KEY",
        "script_slug": "your_script_slug",
        "file_id": FILE_ID_OF_THE_DESIRED_VERSION, // or "version": "1.0.1" if you implement version-based lookup
        "activation_token": "STORED_ACTIVATION_TOKEN" // Optional, but good for extra verification
    }
    ```
*   **Handle Response:**
    *   **Success (e.g., 200 OK):** The API will return a JSON response containing a `download_url` (which includes a temporary, secure token) and `file_name`.
        ```json
        {
            "download_url": "YOUR_APP_URL/api/appmanager/execute-download/SOME_SECURE_TOKEN",
            "file_name": "script-v1.0.1.zip"
        }
        ```
    *   Your script then uses this `download_url` to fetch the file. The token is typically single-use or time-limited.
    *   **Failure:** Handle errors (e.g., no update available, license not permitted for this version).

### Security Considerations for the Client Script:

- **Store License Key and Activation Token Securely:** Avoid hardcoding. Use database options, encrypted files, or appropriate configuration storage.
- **HTTPS:** All API communication with AppManager *must* be over HTTPS.
- **Error Handling:** Implement robust error handling for API request failures.
- **User Feedback:** Provide clear messages to the user regarding activation status, errors, and update processes.