<?php

namespace Modules\AppManager\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\AppManager\Entities\ActivationLog;

class ActivationLogController extends Controller
{
    public function index(Request $request)
    {
        $query = ActivationLog::with(['license', 'license.managedScript'])->orderBy('activated_at', 'desc');

        if ($request->filled('search')) {
            $searchTerm = $request->input('search');
            $query->where(function ($q) use ($searchTerm) {
                $q->where('activated_domain', 'like', "%{$searchTerm}%")
                  ->orWhere('ip_address', 'like', "%{$searchTerm}%")
                  ->orWhereHas('license', function ($lq) use ($searchTerm) {
                      $lq->where('license_key', 'like', "%{$searchTerm}%")
                         ->orWhere('customer_email', 'like', "%{$searchTerm}%");
                  });
            });
        }
         if ($request->filled('status') && $request->status !== 'all') {
            $query->where('status', $request->input('status'));
        }

        $logs = $query->paginate(20)->withQueryString();
        $statuses = ['success' => 'Success', 'failed_invalid_key' => 'Invalid Key', 'failed_limit_reached' => 'Limit Reached', 'failed_expired' => 'Expired', 'failed_domain_mismatch' => 'Domain Mismatch', 'failed_server_error' => 'Server Error'];


        return view('appmanager::admin.activation_logs.index', compact('logs', 'statuses'));
    }
}
