{{-- resources/views/themes/general/sections/team.blade.php --}}
@php
    $sectionTitle = $section->title ?? 'Our Team';
    // Expects an array of team member objects: [['name' => '', 'title' => '', 'image_url' => '', 'social_links' => ['twitter' => '', 'linkedin' => '']]]
    $teamMembers = $section->content['team_members'] ?? [];

    if (empty($teamMembers)) {
        // Fallback to a few example team members
        $teamMembers = [
            ['name' => 'Alice Wonderland', 'title' => 'Lead Developer', 'image_url' => 'https://via.placeholder.com/300x300.png?text=Alice', 'social_links' => ['twitter' => '#', 'linkedin' => '#']],
            ['name' => 'Bob The Builder', 'title' => 'Project Manager', 'image_url' => 'https://via.placeholder.com/300x300.png?text=Bob', 'social_links' => ['linkedin' => '#']],
            ['name' => 'Carol Danvers', 'title' => 'UX/UI Designer', 'image_url' => 'https://via.placeholder.com/300x300.png?text=Carol', 'social_links' => ['twitter' => '#']],
            ['name' => 'David Copperfield', 'title' => 'Marketing Specialist', 'image_url' => 'https://via.placeholder.com/300x300.png?text=David', 'social_links' => []],
        ];
    }
@endphp

<section class="py-16 bg-gray-100 dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-12">
            {{ $sectionTitle }}
        </h2>
        @if(!empty($teamMembers))
        <!-- Swiper -->
        <div class="swiper team-swiper">
            <div class="swiper-wrapper">
                @foreach ($teamMembers as $member)
                    <div class="swiper-slide h-auto p-2">
                        <div class="bg-white dark:bg-gray-700 rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300 h-full">
                            <img src="{{ $member['image_url'] ?? 'https://via.placeholder.com/300x300.png?text=Person' }}" alt="{{ $member['name'] }}" class="w-full h-64 object-cover">
                            <div class="p-4 text-center">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-1">{{ $member['name'] }}</h3>
                                <p class="text-gray-600 dark:text-gray-300 text-sm">{{ $member['title'] }}</p>
                                @if(!empty($member['social_links']))
                                <div class="flex justify-center mt-3 space-x-3">
                                    @if(isset($member['social_links']['twitter']) && !empty($member['social_links']['twitter'])) <a href="{{ $member['social_links']['twitter'] }}" target="_blank" rel="noopener noreferrer" class="text-gray-400 hover:text-purple-500 dark:hover:text-purple-300"><i class="fab fa-twitter"></i></a> @endif
                                    @if(isset($member['social_links']['linkedin']) && !empty($member['social_links']['linkedin'])) <a href="{{ $member['social_links']['linkedin'] }}" target="_blank" rel="noopener noreferrer" class="text-gray-400 hover:text-purple-500 dark:hover:text-purple-300"><i class="fab fa-linkedin"></i></a> @endif
                                    {{-- Add more social links as needed --}}
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <!-- Add Pagination -->
            <div class="swiper-pagination relative pt-8"></div>
        </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400">Our team information will be available soon.</p>
        @endif
    </div>
</section>

@pushOnce('styles')
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
@endPushOnce

@pushOnce('scripts')
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const teamSwiper = new Swiper('.team-swiper', {
                loop: false,
                slidesPerView: 1,
                spaceBetween: 30,
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
                breakpoints: {
                    640: { slidesPerView: 2, spaceBetween: 20 },
                    768: { slidesPerView: 3, spaceBetween: 30 },
                    1024: { slidesPerView: 4, spaceBetween: 30 },
                }
            });
        });
    </script>
@endPushOnce