@php
    // $section is available from the page renderer
    // Default values for section content
    $sectionTitle = $section->content['title'] ?? 'Latest Job Openings';
    $numberOfJobs = (int)($section->content['number_of_items'] ?? 3);
    $viewAllLink = $section->content['view_all_link'] ?? null; // e.g., '/jobs'
    $viewAllText = $section->content['view_all_text'] ?? 'View All Jobs';

    // Fetch jobs from BusinessDirectory module
    try {
        $jobs = \Modules\BusinessDirectory\Entities\Job::query()
            ->where('status', 'open') // Assuming 'open' is the status for active jobs
            ->where(function ($query) { // Handle application deadline
                $query->whereNull('application_deadline')
                      ->orWhere('application_deadline', '>=', now());
            })
            ->orderBy('created_at', 'desc') // Or a specific 'posted_at' date
            ->take($numberOfJobs)
            ->get();
    } catch (\Throwable $e) {
        // Log error or handle gracefully if BusinessDirectory module/model isn't available
        $jobs = collect();
        \Illuminate\Support\Facades\Log::error("Error fetching jobs for landing page section: " . $e->getMessage());
    }
@endphp

@if($jobs->isNotEmpty())
<section class="py-12 md:py-20 bg-white dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-10">{{ $sectionTitle }}</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($jobs as $job)
                <div class="bg-gray-50 dark:bg-gray-700 p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                    <h3 class="text-xl font-semibold text-[var(--clr-accent)] mb-2">{{ $job->title }}</h3>
                    <p class="text-gray-600 dark:text-gray-300 text-sm mb-1"><strong>Company:</strong> {{ $job->company->name ?? 'N/A' }}</p>
                    <p class="text-gray-600 dark:text-gray-300 text-sm mb-3"><strong>Location:</strong> {{ $job->location ?? 'N/A' }}</p>
                    <p class="text-gray-600 dark:text-gray-300 text-sm mb-3">{{ Str::limit($job->description ?? 'No description available.', 100) }}</p>
                    {{-- Link to the job detail page (assuming a route exists in BusinessDirectory) --}}
                    {{-- Example: route('businessdirectory.jobs.show', $job->slug) --}}
                    <a href="{{-- route('module.jobs.show', $job->slug) --}}#" class="text-purple-500 hover:text-purple-700 dark:hover:text-purple-300 font-medium text-sm">Read More &rarr;</a>
                </div>
            @endforeach
        </div>
        @if($viewAllLink)
        <div class="text-center mt-12">
            <a href="{{ url($viewAllLink) }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg transition duration-300">
                {{ $viewAllText }}
            </a>
        </div>
        @endif
    </div>
</section>
@endif