@extends("landingpage::themes.{$activeTheme}.layouts.app")

@section('meta_title', $pageTitle ?? 'Our Products')
@section('meta_description', $metaDescription ?? 'Discover our range of products.')

@section('content')
<div class="bg-gray-50 dark:bg-gray-900 py-12 md:py-20">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-12 text-center">
            <h1 class="text-4xl font-bold text-gray-800 dark:text-white">{{ $pageTitle ?? 'Products' }}</h1>
            @if(isset($metaDescription))
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-300">{{ $metaDescription }}</p>
            @endif
        </header>

        @if($products->isNotEmpty())
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8 mb-12">
                @foreach($products as $product)
                    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 flex flex-col">
                        <a href="{{-- route('module.products.show', $product->slug) --}}#" class="block">
                            @if($product->images && !empty($product->images[0]))
                                <img src="{{ Storage::url($product->images[0]) }}" alt="{{ $product->name }}" class="w-full h-56 object-cover">
                            @else
                                <div class="w-full h-56 bg-gray-200 dark:bg-gray-700 flex items-center justify-center">
                                    <span class="text-gray-500 dark:text-gray-400">No Image</span>
                                </div>
                            @endif
                        </a>
                        <div class="p-6 flex flex-col flex-grow">
                            <h2 class="text-xl font-semibold text-gray-800 dark:text-white mb-2 flex-grow">
                                <a href="{{-- route('module.products.show', $product->slug) --}}#" class="hover:text-[var(--clr-accent)]">
                                    {{ $product->name }}
                                </a>
                            </h2>
                            <p class="text-gray-700 dark:text-gray-300 font-bold text-lg mb-3">
                                ${{ number_format($product->sale_price ?? $product->price, 2) }}
                                @if($product->sale_price && $product->price > $product->sale_price)
                                    <span class="text-sm text-gray-500 dark:text-gray-400 line-through ml-2">${{ number_format($product->price, 2) }}</span>
                                @endif
                            </p>
                            <a href="{{-- route('module.products.show', $product->slug) --}}#" class="mt-auto w-full text-center bg-purple-600 hover:bg-purple-700 text-white font-semibold py-2 px-4 rounded-lg transition duration-300 text-sm">
                                View Details
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            {{-- Pagination Links --}}
            <div class="mt-8">
                {{ $products->links() }}
            </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400 text-xl">No products found at the moment. Please check back later.</p>
        @endif
    </div>
</div>
@endsection